<?php

function createCertification() : array
{
    $cert["Name"] = "";
    $cert["Date"] = "";
    $cert["Comment"] = "";
    return $cert;
}

//**********************************************************
// Edit certifications
//**********************************************************

global $useraeskey,$returnpage,$userid,$myaction;
loadOptionalRequestParameters("useraeskey","returnpage","userid");
if (isEmpty($returnpage)) $returnpage = $page_profile_myprofile;

loadOrCreateProfile($userid,$myprofile,$error,$useraeskey);

$formVisible = true;
$resultVisible = false;

loadMyAction();

$position = -1;

if ($myaction=="delcert")
{
    global $myprofile;

    $position = $_POST["postodel"];
    array_splice($myprofile["Certification"], $position, 1);
    saveProfile($userid,$myprofile,$error,$useraeskey);
}

if ($myaction=="addcert")
{
    global $myprofile;

    if (!is_array($myprofile["Certification"])) $myprofile["Certification"] = [];
    $position = count($myprofile["Certification"]);
    $myprofile["Certification"][$position] = createCertification();
    $myprofile["Certification"][$position]["Name"] = $_POST["cert_type"];
    $myprofile["Certification"][$position]["Date"] = $_POST["cert_date"];
    $myprofile["Certification"][$position]["Comment"] = $_POST["cert_comment"];

    if (!isEmpty($myprofile["Certification"][$position]["Name"]))
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);
    }
}

if ($myaction=="updatecert")
{
    if ($position==-1) $position = $_POST["certposition"];
    $myprofile["Certification"][$position]["Name"] = $_POST["cert_type"];
    $myprofile["Certification"][$position]["Date"] = $_POST["cert_date"];
    $myprofile["Certification"][$position]["Comment"] = $_POST["cert_comment"];

    if (!isEmpty($myprofile["Certification"][$position]["Name"]))
    {
        saveProfile($userid,$myprofile,$error,$useraeskey);    
    }
}

//**********************************************************
// Form components
//**********************************************************

function displayDelButton($position) : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDDELBUTTON
    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="postodel" value="$position" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="delcert" />
        <button class="btn btn-sm btn-default mt-0 collapsed border" type="submit">Remove</button>
    </form>
ENDDELBUTTON;
}

function displayAddButton() : string
{
    global $owpn, $userid, $useraeskey, $returnpage;

    return <<<ENDADDBUTTON
    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="displayaddnew"/>
        <button class="btn btn-primary mt-2" type="submit">Add</button>
    </form>
ENDADDBUTTON;
}

function displayCurrent($position) : string
{
    global $owpn, $myprofile;

    $type=$myprofile["Certification"][$position]["Name"];
    $date=$myprofile["Certification"][$position]["Date"];
    $comment=$myprofile["Certification"][$position]["Comment"];

    return <<<ENDED
    <p class="mt-2 mb-1">
        <strong>$type</strong>
    </p>
    <ul style="list-style-type: none;">
        <li>$date</li>
        <li>$comment</li>
    </ul>
ENDED;
}

function displayAddNewForm() : string
{
    global $myprofile, $owpn, $userid, $useraeskey, $returnpage;

    if(!is_array($myprofile["Certification"]))
	    $position = 0;
    else
	    $position = count($myprofile["Certification"]);

    return <<<ENDADDNEWFORM
<div>
    <form action="index.php" method="POST" novalidate>

        <input type="hidden" name="owpn" value="$owpn" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="useraeskey" value="$useraeskey" />
        <input type="hidden" name="returnpage" value="$returnpage" />
        <input type="hidden" name="myaction" value="addcert" />

        <div class="border p-card rounded mt-2">

            <div class="mb-3">
                <label class="form-label" for="text">Name</label>
                <input class="form-control" name="cert_type"  id="cert_type" type="text"
                       aria-label="cert_type" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
                <label class="form-label" for="text">Date</label>
                <input class="form-control" name="cert_date"  id="cert_date" type="date"
                       aria-label="cert_date" aria-describedby="basic-addon1" />
            </div>

            <div class="mb-3">
                <label class="form-label" for="text">Comment</label>
                <textarea class="form-control" name="cert_comment" id="cert_comment" placeholder="Write here..." rows="3"></textarea>       
            </div>
            <button class="btn btn-primary mt-2" type="submit">OK</button>
        </div>
    </form>

    <form action="index.php" method="post" novalidate>
        <input type="hidden" name="owpn" value="$returnpage" />
        <input type="hidden" name="userid" value="$userid" />
        <input type="hidden" name="myaction" value="" />
        
        <button class="btn btn-danger mt-2" type="submit">Close</button>
    </form>
</div>
ENDADDNEWFORM;
}

function displayCertForm($position) : string
{
    global $owpn, $myprofile, $userid, $useraeskey, $returnpage;

    $type=htmlspecialchars($myprofile["Certification"][$position]["Name"]);
    $date=$myprofile["Certification"][$position]["Date"];
    $comment=htmlspecialchars($myprofile["Certification"][$position]["Comment"]);
    $del = displayDelButton($position);
    $list = displayCurrent($position);

    if (isEmpty($myprofile["Certification"][$position]["Name"])) return "";

    return <<<ENDFORM
    <div class="mb-3">
    
        $list
        <div style="display: flex; flex-direction: row;">
            <a class="btn btn-sm btn-default mt-0 collapsed border" data-bs-toggle="collapse"
             href="#collapseEditCertification$position" role="button" aria-expanded="false"
             aria-controls="collapseEditCertification$position">Edit</a>
             $del
        </div>
           
        <form action="index.php" method="post" novalidate>
        
            <input type="hidden" name="owpn" value="$owpn" />
            <input type="hidden" name="userid" value="$userid" />
            <input type="hidden" name="certposition" value="$position" />
            <input type="hidden" name="myaction" value="updatecert" />
            <input type="hidden" name="useraeskey" value="$useraeskey" />
            <input type="hidden" name="returnpage" value="$returnpage" />
    
            <div class="collapse" id="collapseEditCertification$position">
                <div class="border p-card rounded mt-2">
                 
                    <div class="mb-3">
                        <label class="form-label" for="text">Name</label>
                        <input class="form-control" name="cert_type"  id="cert_type" type="text"
                            aria-label="cert_type" aria-describedby="basic-addon1" value="$type" />
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="text">Date</label>
                        <input class="form-control" name="cert_date"  id="cert_date" type="date"
                            aria-label="cert_date" aria-describedby="basic-addon1" value="$date"/>
                    </div>

                    <div class="mb-3">
                        <label class="form-label" for="text">Comment</label>
                        <textarea class="form-control" name="cert_comment" id="cert_comment" rows="3">$comment</textarea>                            
                    </div>
                        
                    <button class="btn btn-primary mt-2" type="submit">Save</button>
                    
                </div>
            </div>      
        </form>
    </div>
ENDFORM;
}

//**********************************************************
// Design
//**********************************************************
?>

<div class="col-md-6 p-0" style="display: <?php echo ($formVisible) ? "block" : "none"; ?>">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Certifications</h4>
        </div>
        <div class="card-body bg-light pt-2">
        <p>You can add certifications, such as a driver's license, an ECDL certificate, 
            or a first aid certificate, etc...</p>
            <?php
                $cert = $myprofile["Certification"];
                
                if (is_array($cert))
                foreach($cert as $position=>$value)
                {
                    echo displayCertForm($position);
                }

                if ($myaction=="displayaddnew")
                {
                    echo displayAddNewForm();
                }
                else
                {
                    echo displayAddButton();
                }
            ?>
        </div>
    </div>
</div>