<?php

//**************************************************************
// Load defaults
//**************************************************************

function isvalidzipcode($zipcode, &$error) : bool
{
    return true;
}

//**************************************************************
// Edit name
//**************************************************************
global $useraeskey,$returnpage,$userid,$myaction;
loadOptionalRequestParameters("useraeskey","returnpage","userid");
if (isEmpty($returnpage)) $returnpage = $page_profile_myprofile;

loadOrCreateProfile($userid,$myprofile,$error,$useraeskey);

$formVisible = true;
$resultVisible = false;
$zipError = "";
loadMyAction();

#$myaction = $_POST['myaction'];
if ($myaction=="updateaddress")
{
    $myaddress1 = $_POST['myaddress1'];
    $myaddress2 = $_POST['myaddress2'];
    $mycity = $_POST['mycity'];
    $myzip = $_POST['myzip'];
    $mystate = $_POST['mystate'];
    $mycountry = $_POST["mycountry"];

    $myprofile['Address'][0]["Address1"] = $myaddress1;
    $myprofile['Address'][0]["Address2"] = $myaddress2;
    $myprofile['Address'][0]["City"] = $mycity;
    $myprofile['Address'][0]["Zip"] = $myzip;
    $myprofile['Address'][0]["State"] = $mystate;
    $myprofile['Address'][0]["Country"] = $mycountry;

    if (!saveProfile($userid,$myprofile,$error,$useraeskey))
    {
        echo "Could not save profile $error";
        exit;
    }

    $formVisible = false;
    $resultVisible = true;
    echo displaySuccess("Details updated successfully",null,"Go to profile",  $returnpage."&userid=$userid");
}

$myaddress = array_key_exists("Address",$myprofile)&&count($myprofile["Address"])>0 ? $myprofile["Address"][0] : [];
?>

<div class="col-md-6 p-0" style="display: <?php echo ($formVisible) ? "block" : "none"; ?>">
    <div class="card">
        <div class="card-header">
            <h4 class="m-0">Address</h4>
        </div>
        <div class="card-body bg-light pt-2">
            <form enctype="multipart/form-data" action="index.php" method="POST" novalidate>
                <input type="hidden" name="owpn" value="<?php echo $owpn;?>">                
                <input type="hidden" name="userid" value="<?php echo $userid;?>" />
                <input type="hidden" name="useraeskey" value="<?php echo $useraeskey;?>" />
                <input type="hidden" name="returnpage" value="<?php echo $returnpage;?>" />
                <input type="hidden" name="myaction" value="updateaddress">
                <!-- Address1 -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/address.svg" alt="address.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="myaddress1" type="text" placeholder="Address 1" aria-label="Address 1" aria-describedby="basic-addon1" value="<?php echo $myaddress["Address1"] ?? ""; ?>">
                </div>

                <!-- Address2 -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/address.svg" alt="address.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="myaddress2" type="text" placeholder="Address 2" aria-label="Address 2" aria-describedby="basic-addon1" value="<?php echo $myaddress["Address2"] ?? ""; ?>">
                </div>

                <!-- City -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/city.svg" alt="city.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="mycity" type="text" placeholder="City" aria-label="City" aria-describedby="basic-addon1" value="<?php echo $myaddress["City"] ?? ""; ?>">
                </div>

                <!-- Zip -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/zipcode.svg" alt="zipcode.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="myzip" type="text" placeholder="Postal code" aria-label="Postal code" aria-describedby="basic-addon1" value="<?php echo $myaddress["Zip"] ?? ""; ?>">
                </div>
                <div class="form-label mb-3 mt-0"  style="color:red; font-weight:bold"><?php echo $zipError;?></div>

                <!-- State -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/address.svg" alt="address.svg" class="" border=0 width="15px"/></span>
                    <input class="form-control" name="mystate" type="text" placeholder="State/Province/Region" aria-label="State/Province/Region" aria-describedby="basic-addon1" value="<?php echo $myaddress["State"] ?? ""; ?>">
                </div>

                <!-- Country -->
                <div class="input-group mb-3"><span class="input-group-text" id="basic-addon1"><img src="/ozekiservices/profile/attachments/country.svg" alt="ountry.svg" class="" border=0 width="15px"/></span>
                    <?php echo displayCountryCombo("mycountry", $myaddress["Country"] ?? ""); ?>
                </div>

                <!-- OK -->
                <button class="btn btn-primary mt-2" type="submit" name="contact-submit">Save</button>
            </form>
        </div>
    </div>
</div>
