<?php
global $sysdir,$dirprefix;
include_once("$sysdir/form/attrext/combocountry.php");
include_once("$sysdir/services/console.php");
include_once("$dirprefix/ozekiservices/profile/common.php");

//**************************************************************
// Cards / user details
//**************************************************************
function loadUserDetailsForConsole($userid,$consoletype,&$userdetails,&$userprofile,&$error)
{
	global $regdir,$myuserid,$dirprefix;

	if (!ozloadrsaprivatekeyofsharedto($userid,$myuserid,$userrsakey,$error) &&
	    !loadRSAKeyOfUser_SharedToMyConsole($consoletype,$userid,$userrsakey,$error))
	{
		$error = "Cannot load user information. RSA key access failed. $error";
		return false;
	}

	if (!ozloadaeskeyof($userid,$userrsakey,$useraeskey,$error))
	{
		$error = "Cannot load user information. AES key access failed. $error";
		return false;
	}
	
	if (!ozloadencryptedjson($useraeskey,"$regdir/$userid/registration.txt",$userdetails,$error))
	{
		$error = "Cannot load user information. Cannot load registration details. $error";
		return false;
	}

	$profilefile = profileFile($userid);
	if (!ozloadencryptedjson($useraeskey,$profilefile,$userprofile,$error))
	{
		$error = "Cannot load user information. Cannot load user profile. $error";
		return false;
	}

	$error = "True";
	return true;
}

function displayProfileHeaderCard($userid,$consoletype="")
{
	if (!displayProfileHeaderCardHtml($userid,$consoletype,true,$html,$error))
	{
		echo displayErrorCard("User ID: $userid","Cannot display user information.",$error);
	}
	echo $html;
}

function displayProfileHeaderCardHtml($userid,$consoletype,$edit,&$html, &$error)
{
	global $regdir,$myuserid,$dirprefix,$userdetails;
	$html = "";
	$error = "";

	if (!ozloadrsaprivatekeyofsharedto($userid,$myuserid,$userrsakey,$error) &&
	    !loadRSAKeyOfUser_SharedToMyConsole($consoletype,$userid,$userrsakey,$error))
	{
		$error = "RSA key access failed. $error";
		return false;
	}

	if (!ozloadaeskeyof($userid,$userrsakey,$useraeskey,$error))
	{
		$error ="AES key access failed. $error";
		return false;
	}
	
	if (!ozloadencryptedjson($useraeskey,"$regdir/$userid/registration.txt",$userdetails,$error))
	{
		$error = "Cannot load registration details. $error";
		return false;
	}
	
	$profilefile = profileFile($userid);
	if (!ozloadencryptedjson($useraeskey,$profilefile,$userprofile,$error))
	{
		$error = "Cannot load user profile. $error";
		return false;
	}

	$userfullname = $userdetails["fullname"];
	$usernick = $userdetails["nick"] ?? "";
	$usermobile = $userdetails["mobile"];
	$countrybyphone = findCountryByPhone($usermobile);
	$useremail = $userdetails["email"];
	$usercountry = $userdetails["country"];
	if (isset($userdetails["regip"])) 
	{
		$userip = $userdetails["regip"];
	}
	$userregistered = $userdetails["dateregistered"];
	$displayname = $userfullname.((!isEmpty($usernick))?" ($usernick)":"");

	include_once("$dirprefix/ozekiservices/profile/common.php");
	if (!isEmpty($userid) && !loadOrCreateProfile($userid,$userprofile,$error,$useraeskey))
	{
		$error = "Cannot load profile. $error";
		return false;
	}

	if (!is_array($userprofile))
	{
		$error = "Cannot load valid profile.";
		return false;
	}

	//Fix data:
	if (is_array($userprofile) && !array_key_exists("Registration",$userprofile)) 
	{
		$userprofile["Registration"]["Date"] =$userregistered;
		$userprofile["Registration"]["IP"] = $userip;
		$userprofile["Registration"]["Country"] = $usercountry;
		saveProfile(md5($userprofile["Contact"]["Email"]),$userprofile,$error);
		//echo "Profile updated";
	}


	$loginButton = "";
	if (function_exists("displayLoginButton")) 
	{
		global $pass;
		if (!isEmpty($pass)) 
		{
	    	$loginButton = displayLoginButton($userdetails["email"],$pass);
		}
	}

	$card = card($displayname."'s profile",$loginButton,"#7ccde9");
	$card .= "<div class='mx-2'>";
	$card .= displayProfileData($userprofile,$edit,$useraeskey);
	$card .= "</div>";
	$card .= cardend();
	$ret = $card;

	if (isset($userprofile["Mode"]) && $userprofile["Mode"] == "extended") 
	{ 
		//$card = displayProfileDetails($userprofile,$useraeskey);
		//$ret .= $card;
	}

	$html = $ret;
	return true;
}

//**************************************************************
// Cards / Register card
//**************************************************************
global $profilecards;

$profilecards["profile_userheader"]["display"] = "displayProfileHeaderCard";
?>
	
