<?php
//********************************************  
// Dash card: Security questions
//********************************************
include "$sysdir/authentication/secquestions.php";

function dashcardSecurityQuestions($userid)
{
	global $myuserid,$myprivatekey,$owpn;

	global $myaction;
	loadReqParams("myaction");
	$showSecUpdateResult = false;
	$errorSecAnswer1 = "";
	$errorSecAnswer2 = "";
	$errorPassword= "";
	if ($myaction=='savesecurityquestions')
	{
		global $mysecquestion1,$mysecanswer1,$mysecquestion2,$mysecanswer2;
		loadReqParams("mysecquestion1","mysecanswer1","mysecquestion2","mysecanswer2");
		$secquestion1 = $mysecquestion1;
		$secanswer1 = $mysecanswer1;
		$secquestion2 = $mysecquestion2;
		$secanswer2 = $mysecanswer2;

		$datavalid = true;
		if ($datavalid && strlen($secanswer1)<3) 
		{
			$errorSecAnswer1 = "Please provide an answer you will remember.";
			$datavalid = false;
		}

		if ($datavalid && strlen($secanswer2)<3) 
		{
			$errorSecAnswer2 = "Please provide an answer you will remember.";
			$datavalid = false;
		}

		if ($datavalid && !updateSecurityQuestions($myuserid,$myprivatekey, $secquestion1,$secanswer1,$secquestion2,$secanswer2,$error))
		{
			$errorPassword = "Cannot save security questions. ".$error;
			$datavalid = false;
		}

		if ($datavalid)
		{
			$showSecUpdateResult = true;
		}
	}

	if (!isset($secquestion1)) $secquestion1="";
	if (!isset($secquestion2)) $secquestion2="";
	if (!isset($secanswer1)) $secanswer1="";
	if (!isset($secanswer2)) $secanswer2="";

	$combo1 = comboSecurityQuestionSet1("mysecquestion1",$secquestion1);
	$combo2 = comboSecurityQuestionSet2("mysecquestion2",$secquestion2);

$frmSuccess =<<<DCSECQUESUCCESS
	<p class="font-sans-serif lh-1 mb-4 fs-4">Thank you!</p>
	<p class="font-sans-serif lh-1 mb-1 fs-1">The security questions have been successfully updated.</p>
DCSECQUESUCCESS;


$frmAsk =<<<DCSECQUEASK
<div class='mb-2' style='color:red'>Setup your security for password recovery!</div>
<span class="form-label" for="card-mobile" style="color:red; font-weight:bold">$errorPassword</span>
					
<form action='index.php' method='POST'>
<input type='hidden' name='owpn' value='$owpn'>
<input type='hidden' name='myaction' value='savesecurityquestions'>

	<div>
	<label class="form-label" for="card-mobile">First security question</label>
	$combo1
	</div>

	<div class="mb-3">
	<label class="form-label" for="card-mobile">My answer</label>
	<input class="form-control" style="width:unset;font-size:0.8rem" type="mobile" name="mysecanswer1" value="$secanswer1" />
	<span class="form-label" for="card-mobile" style="color:red; font-weight:bold">$errorSecAnswer1</span>
	</div>

	<hr>

	<div>
	<label class="form-label" for="card-mobile">Second security question</label>
	$combo2
	</div>
	<div class="mb-3">
	<label class="form-label" for="card-mobile">My answer</label>
	<input class="form-control"  style="width:unset;font-size:0.8rem" type="mobile" name="mysecanswer2" value="$secanswer2" />
	<span class="form-label" for="card-mobile" style="color:red; font-weight:bold">$errorSecAnswer2</span>
	</div>

	<div class="mb-3">
	<button class="btn btn-primary d-block w-100 mt-3" type="submit" name="submit">Save</button>
	</div>
	</form>
DCSECQUEASK;

	if ($showSecUpdateResult) { 
		//*******************************************
		// Security question update result
		//*******************************************
		$text = $frmSuccess;
	} else { 
		//*******************************************
		// Security question form
		//*******************************************
		$text = $frmAsk;
	}

$content =<<<DCSECQUESTIONS
	$text
DCSECQUESTIONS;

$card = dashcardHeader("Security questions", "#ffc9c9",'showhide2');
$card .= $content;
$card .= dashcardFooter('showhide2');

	return $card;
}


if (isDebug()) return;
if (isset($auth_provider) && ($auth_provider!="basic")) return;
$dashcards["profile_security_questions"]["display"] = "dashcardSecurityQuestions";
$dashcards["profile_security_questions"]["title"] = "Security questions";
$dashcards["profile_security_questions"]["order"] = -1000;
?>
