<?php
include_once("$sysdir/base/image.php");
function profile_uploadimage($uploadedfile,$destdir,$destfilename,&$details,&$error,$isencrypted=false,$aeskey="") {
    $filetype=$uploadedfile["type"];
    if($filetype!=="image/webp" && $filetype!=="image/jpeg" && $filetype!=="image/png")
    {
        $error = "File type is not supported ($filetype).";
        return false;
    }

    if($uploadedfile["size"]>250*1000)
    {
        $error = "File size exceeds the upload limit.";
        return false;
    }

    if(!ozmkdir($destdir,$error))
    {
        $error = "Directory creation failed.";
        return false;
    }

    $fileext = ozfiletypetoextension($filetype);
    $ftemp = ozpathcombine($destdir,$destfilename."_tmp".$fileext);
    if(!move_uploaded_file($uploadedfile["tmp_name"],$ftemp))
    {
        echo "File upload failed.";
        return false;
    }

    $f="";
    if(!$isencrypted)
    {
        $f = ozpathcombine($destdir,$destfilename.".webp");
        if(is_file($f) && !profile_renameuploadedimage($f,$error))
        {
            unlink($ftemp);
            $error = "File save failed.";
            return false;
        }
        if(!savewebp($ftemp,$f,$error))
        {
            //unlink($ftemp);
            return false;
        }
    }
    else
    {
        $f = ozpathcombine($destdir,$destfilename.$fileext."_aes");
        if(is_file($f) && !profile_renameuploadedimage($f,$error))
        {
            unlink($ftemp);
            $error = "File save failed.";
            return false;
        }
        if (!encryptFileAES($aeskey,$ftemp,$f,$error))
        {
            unlink($ftemp);
            $error = "Could not encrypt image.";
            return false;
        }
        unlink($ftemp);
    }

    $details=[];
    $details["filename"] = basename($f);
    $details["content-type"] = $filetype;
    return true;
}

function profile_renameuploadedimage($f,&$error)
{
    if(!is_file($f))
    {
        $error="File does not exists. File $f";
        return false;
    }
    $ext=ozfileextension($f);
    $fstored=dirname($f)."/".basename($f,$ext)."_".date('Ymd_His').$ext;
    if(!ozrename($f,$fstored,$error))return false;
    return true;
}
?>