<?php
global $sysdir;
include_once("$sysdir/base/image.php");
include_once("$sysdir/authentication/registrationcreateuser.php");
include_once("$dirprefix/ozekiservices/profile/common/profileimage.php");

//*********************************************************
// Profile image cache
//*********************************************************

global $profileImageCache;
$profileImageCache = array();

//*********************************************************
// Profile image simple
//*********************************************************
function getOzekiProfileImage($userid,$class="avatar-2xl",$style="padding:0px")
{
	global $profileImageCache,$regdir,$siteurl;
	$cachename = "$userid-$class-$style";
	if (array_key_exists($cachename,$profileImageCache)) return $profileImageCache[$cachename];

	$fullname = GetName($userid);

	$fileinfo = "$regdir/$userid/profile/image/details.json";
	if (!file_exists($fileinfo))
	{
    	$img = getProfileImage_initials($fullname,$class,$style);
		$profileImageCache[$cachename] = $img;
		return $img;
	}
	if (!ozreadjson($fileinfo,$details,$error))
	{
		$img = getProfileImage_initials($fullname,$class,$style);
		$profileImageCache[$cachename] = $img;
		return $img;
	}

	$path = "$regdir/$userid/profile/image/".$details["file"];
	if (!file_exists($path))
	{
		$img = getProfileImage_initials($fullname,$class,$style);
		$profileImageCache[$cachename] = $img;
		return $img;
	}

	$imagefile = "/registrations/$userid/profile/image/".$details["file"];
	$src = "$siteurl/index.php?srv=system&api=imagedownload&path=".urlencode($imagefile);
	return<<<HTML
	<div class="avatar $class">
		<img class="rounded-circle img-thumbnail shadow-sm" src="$src" width="200" style='$style'>
	</div>
	HTML;

	$profileImageCache[$cachename] = $img;
	return true;
}

//*********************************************************
// Profile image details
//*********************************************************
function getProfileImageDetails($userid,&$imgsrc,&$initials,&$color)
{	
	global $regdir,$siteurl;
	$fullname = GetName($userid);
	$color = stringToColor($fullname);
	$initials = getInitials($fullname);
	$imgsrc = "";
	$fileinfo = "$regdir/$userid/profile/image/details.json";
	if (!file_exists($fileinfo)) return;
	if (!ozreadjson($fileinfo,$details,$error)) return;
	$path = "$regdir/$userid/profile/image/".$details["file"];
	if (!file_exists($path)) return;
	$imagefile = "/registrations/$userid/profile/image/".$details["file"];
	$imgsrc = "$siteurl/index.php?srv=system&api=imagedownload&path=".urlencode($imagefile);
}

//*********************************************************
// Profile image src
//*********************************************************
function getProfileImageSrc($userid,&$imgsrc,&$error)
{
	if (!getProfileImagePath($userid,$imagefile,$error)) 
	{
		$imgsrc = "";
		return false;
	}
	$imgsrc = getProfileImageURL($imagefile);
	if ($imgsrc=="") {
		$error = "Could not create profile image URL.";
		return false;
	}
	return true;
}

//*********************************************************
// Profile image file
//*********************************************************
function getProfileImagePath($userid,&$img,&$error)
{
	global $regdir;
	$img = "";
	$defaultimg = "/registrations/$userid/profile/image/profile.webp_aes";
	$fileinfo = "$regdir/$userid/profile/image/details.json";
	if (!file_exists($fileinfo))
	{
		$error = "Could not find profile image info";
    	$img = $defaultimg;
		return false;
	}
	if (!ozreadjson($fileinfo,$details,$error))
	{
		$error = "Could not read profile image json";
    	$img = $defaultimg;
		return false;
	}
	$path = "$regdir/$userid/profile/image/".$details["file"];
	if (!file_exists($path))
	{
		$error = "Could not find profile image file. $path";
    	$img = $defaultimg;
		return false;
	}
	$img = "/registrations/$userid/profile/image/".$details["file"];
	return true;
}

//*********************************************************
// Get image html for display
//*********************************************************

function getProfileImageURL($imagefile,$aeskey=null)
{
	global $datadir,$siteid;
	if (ozendswith($imagefile, ".webp") && file_exists("$datadir/$imagefile")) 
	{
		$src = "index.php?srv=system&api=imagedownload&path=".urlencode($imagefile);
	} 
	else 
	{
		if ($aeskey==null) return "";

		$filekey = $aeskey; //Ezzel titkosítjuk a fájl kulcsát
		$urlkey = convertToAesKey($siteid);
		$keyencrypted = encryptTextAES($urlkey, $filekey); //ez megy az url-be
		$src = "index.php?srv=system&api=imagedownload&path=".urlencode($imagefile)."&k=".urlencode($keyencrypted);
	}

	return $src;
}

function getProfileImageFile($imagefile,$aeskey,$fullname,$class="avatar-5xl",$style="")
{
	global $datadir;
	if(isEmpty($imagefile) || !file_exists("$datadir/$imagefile")) return getProfileImage_initials($fullname,$class,$style);

	$src = getProfileImageURL($imagefile,$aeskey);

	return<<<HTML
<div class="avatar $class">
	<img class="rounded-circle img-thumbnail shadow-sm" src="$src" width="200" style='$style'>
</div>
HTML;
}

function getProfileImage($fullname,$aeskeyofuser,$userid,$class="avatar-5xl",$style="")
{
	global $dirprefix,$datadir,$page_upload_imagedownload;
	getProfileImagePath($userid,$imagefile,$errimg);
	return getProfileImageFile($imagefile,$aeskeyofuser,$fullname,$class);
}

//*********************************************************
// Get initials
//*********************************************************

function getProfileImage_initials($fullname,$class="avatar-5xl",$style="")
{
	$color = stringToColor($fullname);
	$initials=getInitials($fullname);
	return<<<HTML
<div class="avatar $class">
	<div class="avatar-name rounded-circle" style='$style; background-color:$color;'><span>$initials</span></div>
</div>
HTML;
}

//*********************************************************
// Profile image
//*********************************************************

function displayProfileImage($userid,$requestedby,$class="avatar-5xl",$style="")
{
	global $profileImageCache;
	$cachename = "$userid-$class-$style";
	if (array_key_exists($cachename,$profileImageCache)) return $profileImageCache[$cachename];

	$fullname = GetName($userid);

	if (!ozloadrsaprivatekeyof($requestedby,$rsaprivatekey,$error))
	{
		$ret = getProfileImage_initials($fullname,$class,$style);
	} 
	else if (!ozloadaessharedkeyofuser($userid,$requestedby,$rsaprivatekey,$aeskey,$error))
	{
		$ret = getProfileImage_initials($fullname,$class,$style);
	}
	else
	{
		$ret = getProfileImage($fullname,$aeskey,$userid,$class,$style);
	}

	$profileImageCache[$cachename] = $ret;
	return $ret;
}

//*********************************************************
// DecrptyProfileImage
//*********************************************************

function decryptProfileImage($userid,$aeskey,&$error)
{
	global $regdir,$datadir,$profile_image_encrypted;
	if ($profile_image_encrypted)
	{
		$error = "Profile image encryption is enabled. Decryption not possible.";
		return false;
	}

	getProfileImagePath($userid,$imagepath,$errimg);
	if (!isempty($imagepath)) {$imagepath="$datadir$imagepath";}
	if (!file_exists($imagepath)) 
	{
		$error = "Invalid profile image path. $imagepath";
		return false;
	}
	if (!ozendswith($imagepath,"_aes"))
	{
		$error = "Unencrypted files cannot be decrypted";
		return false;
	}

	$ext = pathinfo($imagepath, PATHINFO_EXTENSION);
	$extr = substr($ext,0,strlen($ext)-4);

	if (!loadFileAES($aeskey, $imagepath, $content, $error))
    {
        $error = "Decryption error: $error";
        return false;
    }

	$unencryptedpath = substr($imagepath,0,strlen($imagepath)-4);
	if (!ozsavefile($unencryptedpath,$content,$error))
	{
		$error = "Cannot save unencrpyted profile image file.";
		return false;
	}

	$f = "$regdir/$userid/profile/image/profile.webp";
	if (!savewebp($unencryptedpath,$f,$error))
	{
		$error = "Cannot convert profile image to webp.";
		return false;
	}

	$fileinfo = "$regdir/$userid/profile/image/details.json";
	if (!ozreadjson($fileinfo,$details,$error))
	{
		$error = "Could not read profile image json";
    	return false;
	}

	$details["file"] = "profile.webp";
	$details["content-type"] = "image/webp";
	if (!ozsavejson($fileinfo,$details,$error))
	{
		$error = "Could not save profile image json";
    	return false;
	}

	$error = "";
	return true;
}


//*********************************************************
// Profile color
//*********************************************************

function stringToColor($str)
{
	$code=dechex(crc32($str));
	$code = substr($code,0,6);
	return "#$code";
}

//*********************************************************
// Profile update/remove file
//*********************************************************

function profile_updateprofileimage($userid,$uploadedfile,&$details,&$error){
    global $datadir, $regdir;
    getProfileImagePath($userid,$f,$errimg);
    $f = $datadir.$f;
    if(is_file($f) && !profile_renameuploadedimage($f,$error))
    {
        $error =  "File save failed.";
        return false;
    }

	$d = "$regdir/$userid/profile/image";
    if(!profile_uploadimage($uploadedfile,$d,"profile",$uploaddetails,$error,false)) return false;
    
    $fd="$regdir/$userid/profile/image/details.json";
    $details=[];
    $details["file"]=$uploaddetails["filename"];
    $details["content-type"]=$uploaddetails["content-type"];
    if(!ozsavejson($fd,$details,$error))
    {
        unlink($f);
        $error = "Could not save details.json file.";
        return false;
    }
    return true;
}

function profile_deleteprofileimage($userid,&$error){
	global $datadir;
    if(!getProfileImagePath($userid,$f,$error)) return false;
    $f = $datadir.$f;
    if(is_file($f))
    {
        if(!profile_renameuploadedimage($f,$error)) return false;
    }
	return true;
}
?>