<?php
//**************************************************************
// Common functionality for profile
//**************************************************************
global $dirprefix;
include_once("$dirprefix/ozekiservices/profile/common.profileimage.php");

function profileFile($userid) 
{
	global $regdir;
	$ret = "$regdir/$userid/profile/profiledata.txt";
	if (file_exists($ret)) return $ret;
	return fixMissingProfileFile($ret);
}

function fixMissingProfileFile($filename)
{
	$found = "";
	$x=0;
	while (++$x) 
	{
		$retx = "$filename.$x";
		if (file_exists($retx)) {
			$found = $retx;
			continue;
		}
		break;
	}

	if ($found!="") {
		copy($found,$filename);
		return $filename;
	}
	return $filename;
}

function rotateProfileFile($filename)
{
	if (!file_exists($filename)) return;
	$x=0;
	while (++$x) 
	{
		$filenamenext = "$filename.$x";
		if (file_exists($filenamenext)) continue;
		rename($filename,$filenamenext);
		return;
	}
}

function existsProfile($userid) : bool
{
	return file_exists(profileFile($userid));
}

function saveProfile($userid,$myprofile,&$error,$aeskey=null) : bool
{
	global $myuserid;

	$useremail = $myprofile["Contact"]["Email"];
	if (isEmpty($useremail))
	{
		$error = "Invalid e-mail address in profile.";
		return false;
	}
	$serialized = json_encode($myprofile);
	$filename = profileFile($userid);
	$dir = dirname($filename);
	if (!ozmkdir($dir,$error)) 
	{
		$error = "Cannot save profile. Dir create failed. $error. $dir";
		return false;
	}
	rotateProfileFile($filename);

	if ($myuserid != $userid) 
	{
		if ($aeskey==null && !ozloadaessharedkeyof($userid,$aeskey,$error)) 
		{
			$error = "Cannot save profile. Cannot load AES key. $error";
			return false;
		}
	
		if (!ozsaveencrypted($aeskey,$filename,$serialized,$error)) 
		{
			$error = "Cannot save profile. Cannot save encrypted data. $error";
			return false;
		}
		return true;
	}
	return ozsaveshared($filename,$serialized,$error);
}

function loadProfile($userid,&$myprofile,&$error,$aeskey=null) : bool
{
	global $myuserid;

	$filename = profileFile($userid);
	if (!file_exists($filename))
	{
		$error = "Profile data not found.";
		return false;
	}

	if ($myuserid != $userid) 
	{
		if ($aeskey==null && !ozloadaessharedkeyof($userid,$aeskey,$error)) 
		{
			$error = "Cannot load AES key for user $userid.";
			return false;
		}

		if (!ozloadencrypted($aeskey,$filename,$content,$error)) 
		{
			$error = "Cannot load encrypted profile data for user $userid.";
			return false;
		}
	} 
	else if (!ozloadshared($filename,$content,$error))
	{
		$error = "Cannot load key for encrypted profile data for user $userid.";
		return false;
	}
	$myprofile =  json_decode($content,true);

	return true;
}

function loadOrCreateProfile($userid,&$profile,&$error,$aeskey=null) : bool
{
	if (!existsProfile($userid))
	{
		echo "Creating profile";
		if (!createProfile($userid,$profile,$error,$aeskey)) 
		{
			return false;
		}
		$ret = saveProfile($userid,$profile,$error,$aeskey);
		return $ret;
	}

	$ret = loadProfile($userid,$profile,$error,$aeskey);
	if ($profile==null)
	{
		if (!createProfile($userid,$profile,$error,$aeskey)) return false;
		return saveProfile($userid,$profile,$error,$aeskey);
	}

	return $ret;
}

function createProfile($userid,&$myprofile,&$error,$aeskey=null)
{
	//var_dump($userid);
	global $myuserid;
	if ($myuserid==$userid)
	{
		global $mydetails;
		//var_dump($mydetails);
	} 
	else
	{
		global $regdir;
		$regfile = "$regdir/$userid/registration.txt";
		
		if ($aeskey==null && !ozloadaessharedkeyof($userid,$aeskey,$error)) 
		{
			$error = "Cannot load AES key for user $userid";
			return false;
		}

		if (!ozloadencrypted($aeskey,$regfile,$json,$error))
		{
			$error = "Cannot load registration details for user $userid";
			return false;
		}

		$mydetails = json_decode($json,true);
	}

	return createProfileWithDetails($userid,$mydetails,$myprofile,$error);
}

function createProfileWithDetails($userid,$mydetails,&$myprofile,&$error)
{
	$myprofile["Personal"]["Name"] = $mydetails['fullname'];
	$myprofile["Personal"]["Nick"] = "";
	$myprofile["Personal"]["Company"] = "";
	$myprofile["Personal"]["Position"] = "";
	$myprofile["Personal"]["Country"] = "";
	$myprofile["Personal"]["BirthDay"] = "";
	$myprofile["Personal"]["Gender"] = "";	
	$myprofile["Personal"]["BirthCity"] = "";
	$myprofile["Personal"]["BirthCountry"] = "";
	
	if (isset($mydetails['dateregistered']))
		$myprofile["Registration"]["Date"] = $mydetails['dateregistered'];
	if (isset($mydetails['regip']))
		$myprofile["Registration"]["IP"] = $mydetails['regip'];
	if (isset($mydetails['country']))
		$myprofile["Registration"]["Country"] = $mydetails['country'];
	
	$myprofile["Introduction"]["ElevatorPitch"] = "";
	$myprofile["Introduction"]["Introduction"] = "";
	$myprofile["Introduction"]["ShortTermGoals"] = "";
	$myprofile["Introduction"]["LongTermGoals"] = "";

	$myprofile["Social"]["Twitter"] = "";
	$myprofile["Social"]["Github"] = "";
	$myprofile["Social"]["Facebook"] = "";
	$myprofile["Social"]["Linkedin"] = "";
	$myprofile["Social"]["TikTok"] = "";
	$myprofile["Social"]["Instagram"] = "";
	$myprofile["Social"]["Whatsapp"] = "";
	$myprofile["Social"]["Snapchat"] = "";
	$myprofile["Social"]["Viber"] = "";
	$myprofile["Social"]["Skype"] = "";

	$myprofile["Contact"]["Email"] = $mydetails['email'];
	$myprofile["Contact"]["BackupEmail"] = "";
	$myprofile["Contact"]["Mobile"] = $mydetails['mobile'];
	$myprofile["Contact"]["BackupMobile"] = "";

	$myprofile["Education"][0]["Institute"] = "";
	$myprofile["Education"][0]["Qualification"] = "";
	$myprofile["Education"][0]["Skills"] = "";
	$myprofile["Education"][0]["DateStart"] = "";
	$myprofile["Education"][0]["DateEnd"] = "";

	$myprofile["Language"][0]["Language"] = "";
	$myprofile["Language"][0]["Certification"] = "";
	$myprofile["Language"][0]["Experience"] = "";

    $myprofile['Address'][0]["Name"] = "Default";
    $myprofile['Address'][0]["Address1"] = "";
    $myprofile['Address'][0]["Address2"] = "";
    $myprofile['Address'][0]["City"] = "";
    $myprofile['Address'][0]["Zip"] = "";
    $myprofile['Address'][0]["State"] = "";
    $myprofile['Address'][0]["Country"] = "";

	$myprofile["Skill"][0]["Skill"] = "";
	$myprofile["Skill"][0]["Ability"] = "";

	$myprofile["Certification"][0]["Type"] ="";
	$myprofile["Certification"][0]["Date"] ="";
	$myprofile["Certification"][0]["Comment"] ="";

	$myprofile["Employment"][0]["Company"] = "";	
	$myprofile["Employment"][0]["DateStart"] = "";
	$myprofile["Employment"][0]["DateEnd"] = "";
	$myprofile["Employment"][0]["Location"] = "";
	$myprofile["Employment"][0]["Position"] = "";
	$myprofile["Employment"][0]["Tasks"] = "";

	return true;
}

function enableExtendedProfile($userid)
{
	loadOrCreateProfile($userid,$myprofile,$error);
	if (array_key_exists("Mode",$myprofile) && $myprofile["Mode"] == "extended") return;
	$myprofile["Mode"] = "extended";
	saveProfile($userid,$myprofile,$error);

}

//**************************************************************
// Display profile header
//**************************************************************
function displayProfileCardOfUser($userid,$aeskey)
{
	if (!loadProfile($userid,$profile,$error,$aeskey))
	{
		return displayError("Cannot load user profile",$error);
	}
	return displayProfileCard($profile,$aeskey);
}


function displayProfileCard($myprofile,$aeskey=null)
{
	$headerbar = displayProfileHeaderBar($myprofile,$aeskey);
	$details = displayProfileData($myprofile,true,$aeskey);
$headercard=<<<PRCARDHEAD
	<!-- ------------------------------------------ 
	-- Profile header
	-------------------------------------------- -->
					
	<div class="card mb-3">
		<div class="card-header position-relative min-vh-25 mb-7">
			$headerbar
		</div>
		<div class="card-body">
			$details
		</div>
	</div>
PRCARDHEAD;
	return $headercard;
}

function displayProfileHeaderBar($myprofile,$aeskey=null)
{
	global $dirprefix;

	include_once("$dirprefix/ozekiservices/profile/display/display_profileimage.php");
	$profileimage = display_profileimage($myprofile,$aeskey);

$headerbar=<<<PRCARDHEADBAR
	<!-- ------------------------------------------ 
	-- Profile header bar
	-------------------------------------------- -->
	<div class="bg-holder rounded-3 rounded-bottom-0" style="background-image:url(/ozekiservices/system/attachments/1/falcon/assets/img/generic/4.jpg);">
	</div>

	$profileimage
PRCARDHEADBAR;
	return $headerbar;
}



function displayProfileData($myprofile,$edit,$aeskey=null,$viewdetails=false)
{
	global $dirprefix;

	include_once("$dirprefix/ozekiservices/profile/display/display_profileimage.php");
	$userid=md5($myprofile["Contact"]["Email"]);
	$imageedit=getProfileImageedit($userid,"d-block d-sm-none mb-3");

	include_once("$dirprefix/ozekiservices/profile/display/display_name.php"); 
	$profilename = display_name($myprofile,$edit,$aeskey);

	include_once("$dirprefix/ozekiservices/profile/display/display_address.php"); 
	$address = display_address($myprofile,$edit,$aeskey);

	include_once("$dirprefix/ozekiservices/profile/display/display_contact.php"); 
	$contact = display_contact($myprofile,$edit,$aeskey,$viewdetails);

	include_once("$dirprefix/ozekiservices/profile/display/display_social.php"); 
	$social = display_social($myprofile,$edit,$aeskey);

$header=<<<PRHEAD

<!-- ------------------------------------------ 
-- Profile details
-------------------------------------------- -->
	<div class="row">
		<div class="row g-3 mt-0">
			<div class="col-md-8 mt-0">
				$imageedit
				$profilename
				$address
				$contact				
			</div>
			<div class="col-md-4">
				$social
			</div>						
		</div>		
	</div>

PRHEAD;
			
	return $header;
}

//**************************************************************
// Display profile details
//**************************************************************

function displayProfileDetails($myprofile,$aeskey=null)
{
	global $dirprefix;
	
	include_once("$dirprefix/ozekiservices/profile/display/display_personal.php"); 
	$personal = display_personal($myprofile,$aeskey);

	include_once("$dirprefix/ozekiservices/profile/display/display_education.php"); 
	$education = display_education($myprofile,$aeskey);

	include_once("$dirprefix/ozekiservices/profile/display/display_language.php"); 
	$languages = display_language($myprofile,$aeskey);

	include_once("$dirprefix/ozekiservices/profile/display/display_skill.php");
	$skill = display_skill($myprofile,$aeskey);

	include_once("$dirprefix/ozekiservices/profile/display/display_certification.php"); 
	$certification = display_certification($myprofile,$aeskey);	

	include_once("$dirprefix/ozekiservices/profile/display/display_employment.php"); 
	$employment = display_employment($myprofile,$aeskey);

$details=<<<PRDETAILS
	<!-- ------------------------------------------ 
	-- Personal details
	-------------------------------------------- -->
				
	<div class="card mb-3">
		<div class="card-header mb-0 pb-0" style="background:#004780; color:white">
		    <h3 style='color:white'>Personal details</h3>
		</div>
		<div class="card-body p-3">
			<div>
			$personal
			</div>
		</div>
	</div>

	<!-- ------------------------------------------ 
	-- Educational  details
	-------------------------------------------- -->
			
	<div class="card mb-3">
		<div class="card-header mb-0 pb-0" style="background:#007a80; color:white">
		    <h3 style='color:white'>Educational background</h3>
		</div>
		<div class="card-body p-3">
			<div>
			$education
			</div>
			<div class="mt-4">
			$languages
			</div>
		</div>
	</div>

	<!-- ------------------------------------------ 
	-- Carrier details
	-------------------------------------------- -->
	<div class="card mb-3">
		<div class="card-header mb-0 pb-0" style="background:#80002f; color:white">
		    <h3 style='color:white'>Skills and employment</h3>
		</div>
		<div class="card-body p-3">
			<div>
			$employment
			</div>

			<div class="mt-4">							
			$certification
			</div>

			<div class="mt-4">							
			$skill
			</div>
		</div>
	</div>
		
PRDETAILS;
	return $details;
}


//**************************************************************
// Get profile data
//**************************************************************

function getProfileData($profile,$section,$data)
{
	if (!is_array($profile)) return "";
	if (!array_key_exists($section,$profile)) return "";
	if (!array_key_exists($data,$profile[$section])) return "";
	return $profile[$section][$data];
}

?>
