<?php
//******************************************************
// Ozeki api: profileimage.php
//
// http://localhost/ozeki/index.php?api=profileimage&srv=profile&action=downloadimage
//
// Request
//   Ozeki-User: "9c613d4832453cbf65997912e086be80" // admin userid
//   Ozeki-Signature: "sOSsprxn8l+x6DopDMnxL5J6cdDYF..." // timestamp signed with admin RSA key
//   File: image file// .webp
// Post data: 
//    {
//        "timestamp": timestamp
//        "action": "updateimage",
//        "userid": "9c613d4832453cbf65997912e086be80",
//        }
//
// Response: 
//   {
//	  "status":"OK",
//	  "errormessage":"",
//    "profileimageurl":"index.php?srv=system&api=imagedownload&path=...profile.webp",
//	}
//
//******************************************************
//var_dump($req);

date_default_timezone_set("UTC");
header("Content-Type: application/json");

include_once("$dirprefix/ozekiservices/profile/api/profileimage/profileimage.delete.php");
include_once("$dirprefix/ozekiservices/profile/api/profileimage/profileimage.upload.php");
include_once("$dirprefix/ozekiservices/profile/api/profileimage/profileimage.download.php");

//******************************************************
// Load request
//******************************************************


if (!isValidSignedInput($userid,$stationid,$req,$action,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    $resp=json_encode($resp);
    echo $resp;
    http_response_code(200);
    exit;
}

/*
//$req = $_POST;

if(!checkSignature($req["timestamp"],$userid,$stationid,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    $resp=json_encode($resp);
    echo$resp;
    exit;
}
*/

if(!isValidTimestamp($req,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    $resp=json_encode($resp);
    echo$resp;
    exit;
}

//******************************************************
// Return response
//******************************************************

$action = $req["action"];
switch ($action)
{
    case"downloadimage":
        handlerequest_profileimage_download($userid,$req,$resp,$error);
        break;
    case"updateimage":
        handlerequest_profileimage_update($userid,$req,$resp,$error);
        break;
    case"deleteimage":
        handlerequest_profileimage_delete($userid,$req,$resp,$error);
        break;
    default:
        ozerror(__FILE__,"Invalid conversationgroup action: $action",$resp,$error);
        break;
}

$resp=json_encode($resp);
echo$resp;
?>
