<?php

include_once("$dirprefix/ozekiservices/dashboard/common/common.php");

function dashcardHeader($title, $color, $cardId)
{
    global $error;

    $settings = [];

    loaddashcardsettings($settings, $error);

    $isCollapsed = false;

    for ($i = 0; $i < count($settings); $i++) {
        if ($settings[$i]['id'] == $cardId) {
            $isCollapsed = $settings[$i]['collapsed'];
            break;
        }
    }

    $icon = $isCollapsed ? 'fa-plus' : 'fa-minus';
    $cardBodyDisplay = $isCollapsed ? 'display: none;' : '';
    $cardClass = $isCollapsed ? '' : 'h-md-100';
    $dataIsCollapesed = $isCollapsed ? 'true' : 'false';
    $dflex = $isCollapsed ? '' : 'd-flex';
    $order = $isCollapsed ? '10' : '0';

    $header = <<<HEADER
        <div id="card_$cardId" data-id="$cardId" data-iscollapsed="$dataIsCollapesed" class="col-md-6 col-xxl-3 mb-3" style="order: $order;">
            <div class="card ecommerce-card-min-width $cardClass" style="background-color: $color;" id="cardHeader_$cardId">
                <div class="card-header d-flex justify-content-between align-items-center mt-0 p-2 ps-3 pe-3">
                    <h3 class="mb-1 mt-1">$title</h3>
                    <i id="icon_$cardId" class="fas $icon" style="float: right; color:#5E6E82; cursor: pointer; transition: 0.3s;" onmouseover="this.style.color='#929fb0';" onmouseout="this.style.color='#5E6E82';" onclick="toggleCardBody('$cardId')"></i>
                </div>
                <div class="card-body $dflex flex-column bg-light p-3 pt-1 pb-2" id="cardBody_$cardId" style="$cardBodyDisplay; max-height: 350px; overflow-y: auto;"> 
                    <div class="row mobiledirection">
                        <div class="col mobiledirection font-sans-serif mt-1 mb-1">
    HEADER;

    return $header;
}

function dashcardFooter()
{
    $footer = <<<FOOTER
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                FOOTER;

    return $footer;
}


function cmpDashcards($a, $b)
{
	if (!array_key_exists("order",$a)) $a["order"] = 100;
    if (!array_key_exists("order",$b)) $b["order"] = 100;
    if ($a["order"] == $b["order"]) {
        return 0;
    }
    return ($a["order"] < $b["order"]) ? -1 : 1;
}

function printDashcardShowhideScript()
{
    return "<script src='/ozekiservices/dashboard/attachments/dashcard/dashcard_showhide.js'></script>";
}

function printDashcardCollapsedRow()
{
    return '<div class="row g-3 mt-3 align-items-center" id="collapsedCardsRow"></div>';
}

function printDashcards()
{
    global $dashcards,$myuserid;
    $ret = '<div class="row g-3 mb-3 align-items-start" id="openCardsRow">';
    if (is_array($dashcards))
    {
        usort($dashcards,"cmpDashcards");
        foreach($dashcards as $cardname => $dashcard) 
        {  
            if (!array_key_exists("display",$dashcard)) continue;
            $funcname=$dashcard["display"];
            if (!function_exists($funcname))
            {
                if (isDebug()) $ret .= "Function not found: $funcname";
                continue;
            }
            $ret .= $funcname($myuserid);
        }

    }
    $ret .= '</div>';
    return $ret;
}

?>