<?php

$dashboard_dashcardsettings = null;

function loaddashcardsettings(&$settings, &$error, $usecache = true)
{
    global $dashboard_dashcardsettings;

    if (isset($dashboard_dashcardsettings) && $usecache == true) {
        $settings = $dashboard_dashcardsettings;
        return true;
    }

    //beolvassuk a meglévő fájlt
    settings_readsafe($dashboard_dashcardsettings, $error);

    $settings = $dashboard_dashcardsettings;

    return true;
}

function updatedashcardsettings($isCollapsed, $cardid, &$error)
{
    global $myuserid, $regdir;

    $settings_file = "$regdir/$myuserid/dashcardsettings.json";

    //beolvassuk a meglévő fájlt
    if (!ozfileopenread($settings_file, "c+", LOCK_EX, $contentread, $fh, $error)) {
        $error = "Couldn't read settings file";
        $contentread = [];
    }

    if (empty($contentread)) {
        $data = [];
    } else {
        $data = json_decode($contentread, true);
    }

    if ($data === null && json_last_error() !== JSON_ERROR_NONE) {
        $data = [];
    }

    //megkeressük azt updatelt kártyára vonatkozó részt, és kicseréljük
    $found = false;
    foreach ($data as &$card) {
        if (!isset($card['id']) || $card['id'] != $cardid) continue;

        $card = array('id' => $cardid, 'collapsed' => $isCollapsed);
        $found = true;
        break;
    }

    // ha nincs ilyen kártyára vonatkozó adat, beszúrjuk.
    if (!$found) {
        $data[] = array('id' => $cardid, 'collapsed' => $isCollapsed);
    }

    //visszaírjuk a fájlba a frissített változatot és lezárjuk
    $updated = json_encode($data, JSON_PRETTY_PRINT);

    if (!ozfilewriteclose($fh, $updated, $error)) {
        $error = "Can't write and close the file";
        return false;
    }

    return true;
}

function settings_readsafe(&$settings, &$error)
{
    if (!settings_read($settings, $error)) {
        $settings = [];
        return false;
    }
    if (!is_array($settings)) $settings = [];
    foreach ($settings as $key => &$card) {
        if (settings_isdashcardsettings($card)) continue;
        unset($settings[$key]);
    }
    unset($card);
    $settings = array_values($settings);
    return true;
}

function settings_read(&$settings, &$error)
{
    global $regdir, $myuserid;

    $settings_file = "$regdir/$myuserid/dashcardsettings.json";
    if (!ozreadjson_uselock($settings_file, $settings, $error)) return false;
    return true;
}

function settings_isdashcardsettings($card)
{
    if (!is_array($card)) return false;
    if (!isset($card["id"])) return false;
    if (!isset($card["collapsed"])) return false;
    return true;
}
