"use strict";

function toggleCardBody(cardId) {
    const card = document.getElementById("card_" + cardId);
    if (!card) {
        console.error("Card element not found");
        return;
    }

    const cardHeader = card.querySelector(`#cardHeader_${cardId}`);
    const cardBody = card.querySelector(`#cardBody_${cardId}`);
    const cardIcon = card.querySelector(`#icon_${cardId}`);
    const openCardsRow = document.getElementById("openCardsRow");
    const collapsedCardsRow = document.getElementById("collapsedCardsRow");
    const isCollapsed = card.dataset.iscollapsed === "true";
    cardIcon.style.color = "#5E6E82";

    if (isCollapsed) {
        openCardBody(cardBody, cardHeader, cardIcon, card, openCardsRow);
    } else {
        closeCardBody(cardBody, cardHeader, cardIcon, card, collapsedCardsRow);
    }

    const status = { id: cardId, collapsed: !isCollapsed};
    saveDashcardStatus(status);
}

function openCardBody(cardBody, cardHeader, cardIcon, card, openCardsRow) {
    cardBody.style.display = "block";
    cardBody.classList.add("d-flex");
    cardHeader.classList.add("h-md-100");
    cardIcon.classList.remove("fa-plus");
    cardIcon.classList.add("fa-minus");
    card.style.order = 0;
    card.dataset.iscollapsed = false;
    cardHeader.style.backgroundColor = card.dataset.headercolor;

    const originalIndex = parseInt(card.dataset.listindex);
    insertCard(originalIndex, openCardsRow, card);
}

function insertCard(originalIndex, row, card) {
    if (!isNaN(originalIndex)) {
        let inserted = false;

        for (let i = 0; i < row.children.length; i++) {
            const currentCard = row.children[i];
            const currentCardOriginalIndex = parseInt(currentCard.dataset.listindex);

            if (currentCardOriginalIndex > originalIndex) {
                row.insertBefore(card, currentCard);
                inserted = true;
                break;
            }
        }
        if (!inserted) {
            row.appendChild(card);
        }
    }
}

function closeCardBody(cardBody, cardHeader, cardIcon, card, collapsedCardsRow) {
    cardBody.style.display = "none";
    cardBody.classList.remove("d-flex");
    cardHeader.classList.remove("h-md-100");
    cardIcon.classList.remove("fa-minus");
    cardIcon.classList.add("fa-plus");
    card.style.order = 10;
    card.dataset.iscollapsed = true;
    cardHeader.style.backgroundColor = "#D5D5D5";

    const originalIndex = parseInt(card.dataset.listindex);
    insertCard(originalIndex, collapsedCardsRow, card);
}

function saveDashcardStatus(status) {
    let statusString = JSON.stringify(status);
    console.log("Request: ", statusString);

    fetch("index.php?srv=dashboard&api=dashcardsettings&action=save", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: statusString,
    })
        .then(function (response) {
            return response.text();
        })
        .then(function (bodyText) {
            console.log("Server response:", bodyText);
            let data;
            try {
                data = JSON.parse(bodyText);
                if (data.status == "OK") {
                    console.log("Save successful!");
                } else {
                    console.error("Error: ", data.errormessage);
                }
            } catch (parseError) {
                console.error("JSON parse error:", parseError);
                return;
            }
        })
        .catch(function (error) {
            console.error("Fetch error:", error);
        });
}


function moveCollapsedCardsOnLoad() {
    const collapsedCardsRow = document.getElementById("collapsedCardsRow");
    const openCardsRow = document.getElementById("openCardsRow");
    const cards = openCardsRow.querySelectorAll(":scope > div");

    cards.forEach(function (card, index) {
        card.dataset.listindex = index;
        if (typeof card.dataset.id === "undefined") {
            return;
        }
        const cardId = card.dataset.id;
        const cardHeader = card.querySelector(`#cardHeader_${cardId}`);
        card.dataset.headercolor = cardHeader.style.backgroundColor;

        if (card.dataset.iscollapsed === "true") {
            collapsedCardsRow.appendChild(card);
            cardHeader.style.backgroundColor = "#D5D5D5";
        }
    });
}

moveCollapsedCardsOnLoad();
