<?php

function handlerequest_dashcardsettings_save(&$resp)
{
    global $error;

    //beolvassuk a js által küldött adatot ({id: id, collapsed: true/false})
    $input = file_get_contents('php://input');
    if (!$input) {
        ozerror(__FILE__, "Can't get content.", $resp, $error);
        return;
    }

    //a json dekódolása és ellenőrzése
    $newSettings = json_decode($input, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        $errormessage = "Invalid JSON data: " . json_last_error_msg();
        ozerror(__FILE__, $errormessage, $resp, $error);
        return;
    }

    if (!getreqparamstr($newSettings, "id", $cardid, $resp, $error)) return;

    if (!getreqparambool($newSettings, "collapsed", $isCollapsed, $resp, $error)) return;


    if (updatedashcardsettings($isCollapsed, $cardid, $error)) {
        $resp['status'] = "OK";
        $resp['errormessage'] = "";
    } else {
        $resp['status'] = "Error";
        $resp['errormessage'] = "Couldn't modify or save settings";
    }
}

//******************************************************
// Docs
//******************************************************

// ******************************************************
// ---> add request
// ******************************************************
// $_GET['action'] = 'save';
//
// ******************************************************
// <--- add response
// ******************************************************
// $resp["status"] = "OK"; //OK;ERROR
// $resp["errormessage"] = ""; //Details in case of ERROR   
