<?php
include "$sysdir/authentication/secquestions.php";
//******************************************************
// Ozeki API test
//******************************************************
$accountemail = "";
$questionsDownloaded = false;
loadMyAction();

//******************************************************
// Process form 1: Download security questions
//******************************************************

function downloadQuestions($accountemail,&$req, &$resp, &$errormessage)
{
    $url = "http://localhost/ozeki/index.php?api=api.account.securityquestions&srv=api";

    $request["action"]="api.account.securityquestions.download";
    $request["userid"]=md5($accountemail);
    $req = json_encode($request);
    
    return postJSON($url,$req,$resp,$error,[]);
}

if ($myaction=='downloadQuestions')
{
	$accountemail = $_POST["accountemail"];

    $questionsDownloaded = downloadQuestions($accountemail,$req,$resp,$errormessage);
    
    echo card("Security question download result");
    echo "<h2>Input</h2>";
    echo "email: $accountemail<BR>";
    echo "<HR>";

    echo "<h2>Request</h2>";
    echo $req;

    echo "<HR>";
    echo "<h2>Response</h2>";
    echo $resp;

    $r = json_decode($resp,true);
    $question1 = $r["question1"];
    $question2 = $r["question2"];
    echo cardend();
}

//******************************************************
// Process form 2: Download security questions
//******************************************************

function updatePassword($accountemail,$answer1,$answer2,$newpassword,&$req, &$resp, &$errormessage)
{
    $url = "http://localhost/ozeki/index.php?api=api.account.securityquestions&srv=api";

    $request["action"]="api.account.securityquestions.newpassword";
    $request["userid"]=md5($accountemail);
    $request["answer1"]=$answer1;
    $request["answer2"]=$answer2;
    $request["newpassword"]=$newpassword;
    $req = json_encode($request);
    
    return postJSON($url,$req,$resp,$error,[]);
}

if ($myaction=='updatePassword')
{
	$accountemail = $_POST["accountemail"];
    $answer1 = $_POST["answer1"];
    $answer2 = $_POST["answer2"];
    $newpassword = $_POST["newpassword"];

    $success = updatePassword($accountemail,$answer1,$answer2,$newpassword,$req,$resp,$errormessage);
    
    echo card("Password reset result");
    echo "<h2>Input</h2>";
    echo "email: $accountemail<BR>";
    echo "<HR>";

    echo "<h2>Request</h2>";
    echo $req;

    echo "<HR>";
    echo "<h2>Response</h2>";
    echo $resp;

    echo cardend();
}

//**************************************************************
// Display form 1
//**************************************************************
if ($accountemail=="")
{
    $accountemail = "alice@ozeki.hu";
}

if (!$questionsDownloaded) 
{
    $frmUserid =<<<ENDBTN
    <div class="m-3" style="max-width:600px">
        <form action="index.php" method="post">
        <input type="hidden" name="owpn" value="$owpn">
        <input type="hidden" name="myaction" value="downloadQuestions">
        Account email:<BR>
        <input type="text" name="accountemail" style="width:600px" value="$accountemail"><BR>
        <button class="btn btn-primary mt-3" name="random" type="submit">Check</button>
        </form>
    </div>
ENDBTN;

    echo card("Download account security questions");
    echo $frmUserid;
    echo cardend();
    return;
}

//**************************************************************
// Display form 2
//**************************************************************

$frmPassword =<<<ENDBTN
<div class="m-3" style="max-width:600px">
	<form action="index.php" method="post">
	<input type="hidden" name="owpn" value="$owpn">
    <input type="hidden" name="myaction" value="updatePassword">
	
    Account email:<BR>
    <span style='font-size:16px;font-weight:bold'>$accountemail</span><BR>
    <input type="hidden" name="accountemail" value="$accountemail">
    <BR>

    Question 1:<BR>
    <span style='font-size:16px;font-weight:bold'>$question1</span><BR>

    Answer 1:<BR>
    <input type="text" name="answer1" style="width:600px" value=""><BR>
    <BR>

    Question 2:<BR>
    <span style='font-size:16px;font-weight:bold'>$question2</span><BR>
    
    Answer 1:<BR>
    <input type="text" name="answer2" style="width:600px" value=""><BR>
    <BR>

    New password:<BR>
    <input type="text" name="newpassword" style="width:600px" value=""><BR>

    <button class="btn btn-primary mt-3" name="random" type="submit">Check</button>
	</form>
</div>
ENDBTN;

echo card("Update password");
echo $frmPassword;
echo cardend();

?>