<?php
//**************************************************************
// Help
//**************************************************************
$help=<<<HELPEND
<H3>Introduction</H3>
<p>This service makes it possible for you to generate API keys to let software access your account. 
The reason an API key is better than giving the developer your username and password, 
is because it can be revoked. It can also be labeled with an expiration date to give access for a limited amount of time.</p>

<H3>What is an API key?</H3>
<p>An API key is a 48 character long unique string. This is the actual secret, you pass to your developer instead of your username and password. An API key will allow instant access
to your account. It allows the developer to access your content and associated services you have access to.</p>

<H3>What is an API key hash?</H3>
<p>The API key hash is the SHA 512 hash of the 48 character long api key. This hash is great because it uses a one way encryption. 
Which means, that even if I know the API key hash, I cannot find out what the original API key is. 
The API key hash is sent over the network to protect the API key, and it is used to retrive the API access
details on the server. The API key is not stored on the server, only the API key hash is there, so even if a hacker
gains access to the server files, he cannot get access to the API keys, as they are not stored.</p>


HELPEND;

$helpadmin = "";
if (isDeveloper()||isDecisionmaker()) 
{
    $helpadmin=<<<HELPADMINEND
<H3>What is an API token?</H3>
<p>An API token is stored on the server. It is a set of data that contains information related to the api key. 
It contains a name provided by the user during API key creation. This names helps the user to identify why this 
api key was issued. The API token also contains the expiration date, the encryption type and it contains information 
that helps identify the user asscociated with the api key. Note that the 'Details' information contains the userid hash
only.<p>

<H3>How does it work</H3>
<p>The purpose of the API key system is to give access to the private data of the user for the developer. This data is protected by the user's private key. When 
the user generates and API key he basicly creates a 'secret'. He then takes his private key, and encrypts it with this secrect. The developer can retrive the 
encrpyted private key with the api key hash, and can decrypt it with the api key. Once the developer has retrieved and decrpyted the private key, he can download 
the encrpyted user data and work with it, sinche he is able to read it with the help of the private key.</p>
HELPADMINEND;
}



echo card("How does Ozeki API access work");
echo $help;
echo $helpadmin;
echo cardend();

//**************************************************************
// Display
//**************************************************************

loadApiTokens($myuserid,$myprivatekey,$mytokens, $error);

echo card("My api tokens ($myfullname)");
var_dump($mytokens);
echo cardend();
?>
	