<?php
//*************************************************************
// Hint: Olvasd el a doc.txt-t
//*************************************************************

//**************************************
// API access tokens / Save
//**************************************
function saveMyApiTokens($token,&$eror)
{
    global $myuserid;
    return saveApiTokens($token,$myuserid,$error);
}

function saveApiToken($token,$userid,&$error)
{
    global $regdir;
    $userdir = $regdir."/".$userid;
    if (!is_dir($userdir))
    {
        $error = "User not found";
        return false;
    }
    
    $publicpem = file_get_contents($userdir."/publickey.txt");
    if (!importRsaPublicKeyFromPEM($publicpem,$publickey,$error))
    {
        return false;
    }

    $apidir = $regdir."/".$userid."/api";
    if (!ozmkdir($apidir,$error))
    {
        $error= "Could not create api dir for user $userid. $error";
        return false;
    }

    $tokendir = $regdir."/".$userid."/api/tokens";
    if (!ozmkdir($tokendir,$error))
    {
        $error= "Could not create token dir for user $userid. $error";
        return false;
    }

    $tokenfile =  $tokendir."/".md5($token["ApiKey"]);
    $encodedtoken = json_encode($token);
    $encryptedtoken = encryptTextRSAAES($publickey, $encodedtoken);
    if (!ozsavefile($tokenfile, $encryptedtoken, $error))
    {
        return false;
    }
    return true;
}

//**************************************
// API access tokens / Load
//**************************************

function loadOrGenerateMyApiToken($keyname,&$apikey,&$error)
{
    global $myuserid,$myprivatekey;
    return loadOrGenerateApiToken($myuserid,$myprivatekey,$keyname,$apikey,$error);
}

function loadMyApiTokens()
{
    global $myuserid,$myprivatekey;
    loadApiTokens($myuserid,$myprivatekey,$tokens,$error);
}

function loadOrGenerateApiToken($userid,$privatekey,$keyname,&$apikey,&$error)
{
    loadApiTokens($userid,$privatekey,$tokens,$error);
    $now=time();
    foreach($tokens as $t)
    {
        if($t["Name"]!==$keyname)continue;
        $expires=strtotime($t["Expires"]);
        if($expires<$now)continue;
        $apikey=$t["ApiKey"];
        return true;
    }
    return generateMyApiTokenRSA($keyname,$apikey,$error);
}

function loadApiTokens($userid,$privatekey,&$tokens, &$error)
{
    global $regdir,$datadir;
    $tokendir = $regdir."/".$userid."/api/tokens";

    if (!is_dir($tokendir))
    {
        $tokens=[];
        $error = "Token dir does not exist";
        return false;
    }

    if (!ozlsdir($tokendir, $files, $dirs, $error))
    {
        $tokens=[];
        $error = "No tokens found";
        return false;
    }

    $tokens = [];
    foreach($files as $file)
    {
        $filename = $tokendir."/".$file;
        $encrypted = file_get_contents($filename);
        if (!decryptTextRSAAES($privatekey, $encrypted,$jsondata,$error)) 
            continue;
        $token = json_decode($jsondata,true);
        $token["Details"] = $filename;
        $key= HexToStr($token["ApiKey"]);
        $hash = sha512($key);
        $token["Access"] = "$datadir/services/api/tokens/token_rsa_".$hash.".txt";
        $tokens[] = $token;
    }

    $error = "";
    return false;
}

//**************************************
// API access tokens / Generate
//**************************************

function generateMyApiTokenRSA($keyname,&$apikey,&$error)
{
    global $myuserid,$myprivatekey;
    return generateApiTokenRSA($keyname,null,$myuserid,$myprivatekey,$apikey,$error);
}

function generateApiTokenRSA($keyname,$validityinsec,$userid,$privatekey,&$apikey,&$error)
{
    global $datadir;

    //Generate access token
    $key = generateAesKey();
    $apikey = strToHex($key);
    if ($validityinsec==null) $validityinsec=100*365*24*60*60;
    $created = time();
    $exp = $created+$validityinsec;

    //Save access token key for user
    $token["Created"] = date("Y-m-d H:i:s",$created);
    $token["Creator"] = $_SERVER['REMOTE_ADDR'];
    $token["Expires"] = date("Y-m-d H:i:s",$exp);
    $token["Name"] = $keyname;
    $token["ApiKey"] = $apikey;
    $token["Type"] = "RSA";
    if (!saveApiToken($token,$userid,$error))
    {
        return false;
    }

    //Save access token for api access
    $hash = sha512($key);
    $datadir_api_tokens = "$datadir/services/api/tokens";
    $accessfile = $datadir_api_tokens."/token_rsa_".$hash.".txt";
    
    $pemprivate = exportRsaPrivateKeyToPEM($privatekey,$key);
    $access["User"] = $userid;
    $access["Expires"] = $exp;
    $access["Pem"] = $pemprivate;
    $access["Name"] = $keyname;
    $serialized = json_encode($access);

    if (!ozmkdir($datadir_api_tokens,$error))
    {
        $error = "Could not create dir ($datadir_api_tokens). $error";
        return false;
    }
    if (!file_put_contents($accessfile,$serialized))
    {
        $error = "Cannot write access token ".error_get_last()["message"];
        return false;
    }

    return true;
}

//**************************************************************
// Access token based information retrival
//**************************************************************
function getApiAccessInfo($apikeyhash,&$accessinfo,&$error)
{
    global $datadir;
    $apikeyhash = strtoupper($apikeyhash);
    if (!issha512($apikeyhash))
    {
        $error = "Invalid api key hash. This is not an sha512 hash.";
        return false;
    }

    $tokenfile = "$datadir/services/api/tokens/token_rsa_".$apikeyhash.".txt";
    if (!ozreadfile($tokenfile,$tokendata,$error))
    {
        $error = "Invalid api key hash";
        return false;
    }
    
    $accessinfo = json_decode($tokendata,true);
    return true;
}

//**************************************************************
// Access token based information retrival
//**************************************************************
function getUserDetails($accesstoken,&$userid,&$privatekey,&$details,&$error)
{
    global $datadir,$regdir;

    $details = "";
    $error = "";
    $private = null;
    
    $key= HexToStr($accesstoken);
    $hash = sha512($key);
    $tokenfile = "$datadir/services/api/tokens/token_rsa_".$hash.".txt";
    if (!ozreadfile($tokenfile,$tokendata,$error))
    {
        $error = "Invalid api key";
        if (isDebug()) $error.= " ".$error;
        return false;
    }

    $access = json_decode($tokendata,true);
    $userid = $access["User"];
    $privatepem = $access["Pem"];
    if (!importRsaPrivateKeyFromPEM($privatepem,$key,$privatekey,$publickey,$errorpi))
    {
        $error = "Private key import failed. $errorpi";
        return false;
    }
    
    if (!loadPersonalDetails($userid,$privatekey,$details, $errorpd))
    {
        var_dump($userid);
        var_dump($privatekey);
        $error = "Personal details could not be loaded. $errorpd";
        return false;
    }

    return true;
}

function loadPersonalDetails($userid,$privatekey,&$details, &$error)
{
    global $regdir;
     
    if (!is_resource($privatekey) && !is_object($privatekey))
    {
        $error = "Invalid private key. It is not a resource.";
        return false;
    }

    if (!ismd5($userid))
    {
        $error = "Invalid user id. It is not an md5 hash.";
        return false;
    }

    $aesprivatefile = "$regdir/$userid/aesshared.txt";
    if (!ozreadfile($aesprivatefile,$encryptedaesprivate,$error))
    {
        $error = "Invalid api key";
        if (isDebug()) $error.= ". Could not load aes key.";
        return false;
    }

    if (!decryptTextRSA($privatekey,$encryptedaesprivate,$aeskey,$error))
    {
        $error = "Invalid api key";
        if (isDebug()) $error.= ". Could not decrypt key.";
        return false;
    }
    
    $detailsfile = "$regdir/$userid/registration.txt";
    if (!ozreadfile($detailsfile,$detailsencrpyted,$error))
    {
        $error = "Invalid api key";
        if (isDebug()) $error.= ". Could not load aes key.";
        return false;
    }
    
    $detailsjson = decryptTextAES($aeskey,$detailsencrpyted);
    $details = json_decode($detailsjson,true);
    return true;
}

?>
