<?php
include_once("$dirprefix/ozekiservices/api/common.php");

function handlerequest_apikey_getapikey($req, &$resp) {

    if (!getreqparamstr($req, "keyname", $keyname, $resp, $error)) {
        return false;
    }
    if (!getreqparamstr($req, "userid", $userid, $resp, $error)) {
        return false;
    }
    if (!getreqparamstr($req, "password", $password, $resp, $error)) {
        return false;
    }

    if (!userExists($userid)) {
        return ozerror(__FILE__,"User not found.", $resp, $error);
    }

    global $regdir;
    if (!is_dir("$regdir/$userid"))
    {
        return ozerror(__FILE__, "User not found.", $resp, $error);
    }
    
    $pwhash = sha512($req["password"]);

    $privatekeyfile = "$regdir/$userid/privatekey_".strtoupper($pwhash).".txt";
    if (!file_exists($privatekeyfile))
	{
		return ozerror(__FILE__, "Private key not found.", $resp, $error);
	}
    
    $privateKeyPem = file_get_contents($privatekeyfile);
    if (!importRsaPrivateKeyFromPEM($privateKeyPem, $password, $privateKey, $publicKey, $error)) {
        return ozerror(__FILE__, "Couldn't import private key", $resp, $error);
    }

    if (!generateApiTokenRSA($keyname, null, $userid, $privateKey, $apikey, $error)) {
        return ozerror(__FILE__, "Couldn't generate api key", $resp, $error);
    }

    $resp = [
        "status" => "OK",
        "errormessage" => $error,
        "keyname" => $keyname,
        "apikey" => $apikey,
    ];
    return true;
}
?>