<?php
date_default_timezone_set("UTC");
header("Content-Type: application/json");

include_once("$dirprefix/ozekiservices/api/api/v2.0/apikey/getapikey.php");

//******************************************************
// Load request
//******************************************************
$resp = [];
$inputData = json_decode(file_get_contents("php://input"), true);

if (!isset($inputData["action"])) {

    ozerror(__FILE__, "The request does not contain an action.", $resp, $error);
    $resp = json_encode($resp);
    echo $resp;
    exit;

}

$action = $inputData["action"];

//******************************************************
// Return response
//******************************************************

switch ($action) {
    case "getapikey":
        handlerequest_apikey_getapikey($inputData, $resp);
        break;
    default:
        ozerror(__FILE__, "Invalid API key action: $action", $resp, $error);
        break;
}

$resp = json_encode($resp);
echo $resp;
?>