<?php
//******************************************************
// Ozeki api: update.php
//
// http://localhost/ozeki/index.php?api=account&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
//    {
//        "action": "update",
//        "userid": "9c613d4832453cbf65997912e086be80",
//        "fullname": "Test 2",
//        "nickname": "Test 2",
//        "qualifications": ["testuser"],//exstaff, decisionmaker, developer, testuser, serviceuser
//        "registration": "",//fullname, phone number
//        "pwhash": "",//sha512(pw)
//        "pwupdatemode": "add",//add, overwrite required for password change
//        "pwemailrequest": true, // required for password change
//        "privatekey": "",//encrypted by user pass required for password change
//        }
//
// Response: 
//   {
//	  "status":"OK",
//	  "errormessage":"",
//	}
//
//******************************************************
include_once("$dirprefix/ozekiservices/api/common.php");
include_once("$dirprefix/ozekiservices/profile/common.php");


function handlerequest_user_update($adminid,$stationid,$req,&$resp,&$errormessage){
    if(!getreqparamstr($req,"userid",$userid,$resp,$error)) return false;
    if(!isAdmin($adminid)){
        $errormessage = "Only administrators are authorized to change edit users";
        return false;
    }
    //check params
    if(!handlerequest_user_update_name($userid,$req,$errormessage,true)) return false;
    if(!handlerequest_user_update_registration($userid,$req,$errormessage,true)) return false;
    if(!handlerequest_user_update_qualifications($userid,$req,$errormessage,true))return false;
    if(!handlerequest_user_update_password($adminid,$userid,$req,$errormessage,true)) return false;
    //execute request
    if(!handlerequest_user_update_name($userid,$req,$errormessage)) return false;
    if(!handlerequest_user_update_registration($userid,$req,$errormessage)) return false;
    if(!handlerequest_user_update_qualifications($userid,$req,$errormessage)) return false;
    if(!handlerequest_user_update_password($adminid,$userid,$req,$errormessage)) return false;
    if(!handlerequest_user_update_password($adminid,$userid,$req,$error)) return false;
    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    return true;
}

function handlerequest_user_update_name($userid,$req,&$error,$onlycheck = false){
    if(!getreqparamstropt($req,"fullname",$fullname,$resp,$error,false)) return false;
    if(!getreqparamstropt($req,"nickname",$nickname,$resp,$error,false)) return false;
    if($fullname == false && $nickname == false) return true;
    if($onlycheck) return true;
    getNameAndNick($userid,$oldfullname,$oldnick);
    $fullname = $fullname ?? $oldfullname;
    $nickname = $nickname ?? $oldnick;
    if($nickname == "") $nickname = $fullname;
    updatePublicDetails($userid,$fullname,$nickname);
    
    /* 
    if(!getreqparamstr($req,"aesshared",$aeskey,$resp,$error)) return false;
    if(!loadOrCreateProfile($userid,$myprofile,$error,$aeskey)) return false;
    $myprofile["Personal"]["Name"] = $fullname;
    $myprofile["Personal"]["Nick"] = $nickname;
    if(!saveProfile($userid,$myprofile,$error,$aeskey))return false; */
    return true;
}

function handlerequest_user_update_registration($userid,$req,&$error,$onlycheck = false){
    global $regdir;
    if(!getreqparamstropt($req,"registration",$registration,$resp,$error,false)) return false;
    if($registration == false) return true;
    if($onlycheck) return true;
    $regfile = "$regdir/$userid/registration.txt";
    rotateRegistrationFile($userid);
    if (!file_put_contents($regfile,$registration))
	{
		$error = "Cannot write registration file ".error_get_last()["message"];
		return false;
	}
	return true;
    /* if(!updateUserDetails($userid,$registration,$errorm,$aeskey)) return false;

    if(!loadOrCreateProfile($userid,$myprofile,$error,$aeskey)) return false;
    $myprofile["Contact"]["Email"] = $registration["email"];
    $myprofile["Contact"]["Mobile"] = $registration["mobile"];
    if(!saveProfile($userid,$myprofile,$error,$aeskey))return false; */
}

function rotateRegistrationFile($userid){
    global $regdir;
    $regfile = "$regdir/$userid/registration.txt";
    if (!file_exists($regfile)) return;
    $i = 0;
    while (file_exists("$regdir/$userid/registration.{$i}.txt")) {
        $i++;
    }
    rename($regfile, "$regdir/$userid/registration.{$i}.txt");
}

function handlerequest_user_update_qualifications($userid,$req,&$error,$onlycheck = false){
    if(!isset($req["qualifications"])) return true;
    if(!getreqparamstrarr($req,"qualifications",$qualifications,$resp,$error,false)) return false;
    if($qualifications == false) return true;
    if($onlycheck) return true;
    if(!setUserQualifications($userid,$qualifications,$error)) return false;
    return true;
}


function handlerequest_user_update_password($adminid,$userid,$req,&$error,$onlycheck = false){
    if(!isset($req["pwhash"])) return true;
    if(!getreqparamstropt($req,"pwhash",$pwhash,$resp,$error,false)) return false;
    if($pwhash&&!getreqparamstr($req,"pwupdatemode",$overwrite,$resp,$error)) return false;
    if($pwhash&&!getreqparambool($req,"pwemailrequest",$pwemailrequest,$resp,$error)) return false;
    if($pwhash&&!getreqparamstr($req,"privatekey",$pemprivate,$resp,$error)) return false;
    if($onlycheck) return true;
    if(!api_resetpassword($adminid,$userid,$pwhash,$overwrite,$pemprivate,$error))return false;
    if($pwemailrequest){
        if(!api_sendpasswordreset_email($userid,$pwhash,$error)) return false;
    }
    $error = "";
    return true;
}
//**************************************************************
// Password
//**************************************************************
function api_resetpassword($adminid,$userid,$pwhash,$overwrite,$pemprivate,&$error){
    global $regdir;
    $userdir = "$regdir/$userid";
    if ($overwrite == "overwrite"){
		ozlsdir($userdir, $files, $dirs, $error);
		foreach($files as $file) {
			if (!ozstartswith($file,"privatekey_")) continue;
			if (file_exists($userdir."/".$file.".readonly")) continue;
			if (ozendswith($file,".readonly")) continue;
			$pemprivatefiletodel = $userdir."/".$file;
			unlink($pemprivatefiletodel);
		}
	}
    $pemprivatefile = $userdir."/privatekey_".$pwhash.".txt";
    if (!file_put_contents($pemprivatefile,$pemprivate))
	{
		$error = "Cannot write user private key ".error_get_last()["message"];
		return false;
	}

    $prstoadminfile =  "$userdir/sharedto/$adminid"."_rsa.txt";
	if (!file_exists($prstoadminfile))
	{
        ozloadrsapublickeyof($adminid,$adminpublickey,$error);
		$prstoadmin = encryptTextRSAAES($adminpublickey,$pemprivate);
		if (!file_put_contents($prstoadminfile,$prstoadmin))
		{
			$error = "Cannot write admin prs file ".error_get_last()["message"];
			return false;
		}
	}
    return true;
}
function api_sendpasswordreset_email($userid,$pwhash,&$error){
    global $dirprefix,$regdir,$siteid,$sitetitle, $siteemail, $siteurl;
    include_once("$dirprefix/ozekiservices/emailclient/common.php");
    $useremail = "";//TODO get user email
    if(!$useremail){
        $error = "Cannot load user email.";
        return false;
    }
    $name = GetName($userid);
    $validuntil = mysqldateadd(mysqldateutc(),'+ 7 days');
    $passwordresetinfo = [];
    $passwordresetinfo["u"]=$userid; //user id
    $passwordresetinfo["v"]=$validuntil; //valid until
    $req = json_encode($passwordresetinfo);
    $key = convertToAesKey($siteid);
    $enc = encryptTextAES($key,$req);

    $expfile = "$regdir/$userid/privatekey_".$pwhash.".until";
    ozsavefile($expfile,$validuntil,$error);
    
    $subject = "[$sitetitle] password reset";
    $link = "$siteurl/index.php?api=resetpassword&srv=system&c=".$enc;
    $text = <<<PASSWORDRESETEMAIL
    Hello $name,

    Please click on the following link to reset your password:
    $link

    The above link is valid until: $validuntil

    Best regards,

    $sitetitle
    PASSWORDRESETEMAIL;
    if (!sendEmailMessage($sitetitle,$siteemail,$name,$useremail,$subject,$text,$errorm))
    {
        $error = "Could not send e-mail to '$useremail'. ".$errorm;
    }
    return true;
}
?>