<?php
//******************************************************
// Ozeki api: accountcreate.php
//
// http://localhost/ozeki/index.php?api=account.api.securit
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
//   {"action":"api.account.securityquestions.update","userid":"f17c01af66aa70508d31d99b87976fa3","password":"qwe123","question1":"In which city did your parents meet?","answer1":"budapest","question2":"What is the name of your grandmother's dog?","answer2":"bloki"}
//
// Response: 
//   Content-Type: application/json
// Response data: 
//   {"status":"OK","errormessage":"","accountstatus":"notfound"}
//******************************************************

include_once("$sysdir/authentication/users.php");
include_once("$sysdir/authentication/secquestions.php");
include_once("$sysdir/authentication/login.inc.php");

//******************************************************
// Load the request
//******************************************************

function handlerequest_account_updatesecquestions($stationid,$userid,$req,&$resp,&$error)
{
    global $regdir;

    //Check user id
    if (!ismd5($userid))
    {
        $error = "Invalid user id.";
        return false;
    }

    if (!userExists($userid))
    {
        $error = "User not found.";
        return true;
    } 

    if (!isset($req["question1"]) || isempty($req["question1"]))
    {
        $error = "Security question 1 is invalid.";
        return false;
    }
    $secquestion1 = $req["question1"];

    if (!isset($req["question2"]) || isempty($req["question2"]))
    {
        $error = "Security question 2 is invalid.";
        return false;
    }
    $secquestion2 = $req["question2"];

    if (!isset($req["encryptedprivatekey"]) || isempty($req["encryptedprivatekey"]))
    {
        $error = "Encrypted privatekey is invalid.";
        return false;
    }
    $encryptedprivatekey = $req["encryptedprivatekey"];

    $secquestionsfile = "$regdir/$userid/secquestions.txt";
    $secquestions = $secquestion1."\r\n".$secquestion2;
    if (!ozsavefile($secquestionsfile,$secquestions,$error))
    {
        $error= "Cannot write security questions file. ".$error;
        return false;
    }

    $pemprivatefilesecquestions = "$regdir/$userid/recoverykey.txt";
    if (!ozsavefile($pemprivatefilesecquestions,$encryptedprivatekey,$error))
    {
        $error= "Cannot write security answer file. ".$error;
        return false;
    }

    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    echo json_encode($resp);
    exit;
}


?>