<?php

//******************************************************
// Ozeki api: accountlogin.php
//
// http://localhost/ozeki/index.php?api=account&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
//   {
//   "action":"loginapi",
//   "userid":"d574638619cbff603bf857164c47e850",
//   "apikiey":""
//   }
//
// Response: 
//   Content-Type: application/json
// Response data: 
//   {
//    "status":"OK",
//    "errormessage":"",
//    "privatekey":"",
//    "aesprivatekey":"",
//    "aessharedkey":"",
//    "registration":"",
//    "isadmin":true,
//    "userid":"",
//   }

function handlerequest_account_login_api($stationid,$req,&$resp,&$error){
    global $dirprefix,$regdir;
    $apikey = $req["apikey"] ?? null;
    if (!isset($apikey)){
        $error = "Missing apikey";
        return false;
    }

    if (strlen($apikey)==88)
    {
        $key= HexToStr($apikey);
        $apikey = sha512($key);
    }

    if (strlen($apikey)!=128){
        $error = "Invalid api key length.";
        return false;
    }
    $apicommon = "$dirprefix/ozekiservices/api/common.php";
    if (!file_exists($apicommon))
    {
        $error = "The api service is not installed.";
        return false;
    }
    include_once($apicommon);
    if (!getApiAccessInfo($apikey,$accessinfo,$error))
    {
        $error = "Api access information not available.";
        return false;
    }
    $userid = $accessinfo["User"];

     if (isset($req["stationid"]) && 
        !isempty($req["stationid"]) &&
        !isempty($req["hardwareid"]))
    {
        if (!registerStation($req["userid"],
            $req["stationid"],
            $req["hardwareid"],
            $req["devicename"],
            $req["os"],
            $req["hdd"],
            $req["ram"],
            $req["cpu"],
            $error))
        {
            ozerror(__FILE__,$error,$resp,$error);
        }
    }
    $privatekeypem = $accessinfo["Pem"];
    $resp = login_api_resp_success($userid,$privatekeypem);
    return true;
}

function login_api_resp_success($userid,$privatekeypem)
{
    global $regdir;

    $aessharedfile = "$regdir/$userid/aesshared.txt";
    ozreadfile($aessharedfile, $aessharedencrypted, $error);

	$aesprivatefile = "$regdir/$userid/aesprivate.txt";
    ozreadfile($aesprivatefile, $aesprivateencrypted, $error);

	$regfile = "$regdir/$userid/registration.txt";
    ozreadfile($regfile, $regdata, $error);

    $resp = [];
    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    $resp["privatekey"] = $privatekeypem;
    $resp["aesprivatekey"] = $aesprivateencrypted;
    $resp["aessharedkey"] = $aessharedencrypted;
    $resp["registration"] = $regdata;
    $resp["userid"] = $userid;
    $resp["isadmin"] = isDecisionMaker($userid);
    $resp["isdeveloper"] = isDeveloper($userid);
    $resp["fullname"] = GetName($userid);

    return$resp;
}

?>