<?php
//******************************************************
// Ozeki api: authenticate.php
//
// http://localhost/ozeki/index.php?api=account&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
//   {
//    "action": "login",
//    "userid": "d574638619cbff603bf857164c47e850",
//    "username": "alice@ozeki.hu", //mandatory if no userid
//    "pwhash": sha512(password),
//    "password": "abc123", //mandatory if no pwhash
//    "role": "admin", //optional
//    "stationid", OzFeatureMyComputer.StationID; //optional
//    "hardwareid", OzFeatureMyComputer.Instance.Hardware.ID; //optional
//    "hardwareserial", OzFeatureMyComputer.HardwareID; //optional
//    "devicename", OzFeatureMyComputer.Instance.HardwareDescription.DeviceName; //optional
//    "os", OzFeatureMyComputer.Instance.HardwareDescription.OSVersion; //optional
//    "hdd", OzHDDInformationProvider.GetDescription(); //optional
//    "ram",  OzMemoryInformationProvider.GetDescription(); //optional
//    "cpu", OzCPUInformationProvider.GetCPUDescription(); //optional
//   }
//
// Response: 
//   Content-Type: application/json
// Response data: 
//   {
//    "status":"OK",
//    "errormessage":"",
//    "privatekey":"",
//    "aesprivatekey":"",
//    "aessharedkey":"",
//    "registration":""
//   }
//
//******************************************************


function handlerequest_account_login($stationid,$req,&$resp,&$errormessage)
{
    $userid = "";
    if(isset($req["username"]))
        $userid=md5($req["username"]);
    if(isset($req["userid"]))
        $userid=$req["userid"];

    if (!ismd5($userid))
    {
        $errormessage = "Invalid userid format.";
        return false;
    }

    global $regdir;
    if (!is_dir("$regdir/$userid"))
    {
        $errormessage = "User not found.";
        return false;
    }

    if(isset($req["role"])&&!hasRole($userid,$req["role"],$error))
    {
        $errormessage=$error;
        return false;
    }

    $pwhash="";
    if(isset($req["password"]))
        $pwhash=sha512($req["password"]);
    if(isset($req["pwhash"]))
        $pwhash=$req["pwhash"];

    if (!issha512($pwhash))
    {
        $errormessage = "Invalid password format.";
        return false;
    }

    $privatekeyfile = "$regdir/$userid/privatekey_".strtoupper($pwhash).".txt";
    if (!file_exists($privatekeyfile))
    {
        $errormessage = "Invalid password.";
        return false;
    }

    if (!ozreadfile($privatekeyfile,$pkencoded,$error))
    {
        $errormessage = "Could not read password.";
        return false;
    }

    $publickeyfile = "$regdir/$userid/publickey.txt";
    ozreadfile($publickeyfile, $publickey, $error);

	$aessharedfile = "$regdir/$userid/aesshared.txt";
    ozreadfile($aessharedfile, $aessharedencrypted, $error);

	$aesprivatefile = "$regdir/$userid/aesprivate.txt";
    ozreadfile($aesprivatefile, $aesprivateencrypted, $error);

	$regfile = "$regdir/$userid/registration.txt";
    ozreadfile($regfile, $regdata, $error);

    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    $resp["privatekey"] = $pkencoded;
    $resp["publickey"] = $publickey;
    $resp["aesprivatekey"] = $aesprivateencrypted;
    $resp["aessharedkey"] = $aessharedencrypted;
    $resp["registration"] = $regdata;

    if (isset($req["stationid"]) && 
        !isempty($req["stationid"]) &&
        !isempty($req["hardwareid"]))
    {
        if (!registerStation($req["userid"],
            $req["stationid"],
            $req["hardwareid"],
            $req["devicename"],
            $req["os"],
            $req["hdd"],
            $req["ram"],
            $req["cpu"],
            $error))
        {
            ozerror(__FILE__,$error,$resp,$error);
        }
    }

    return true;
}

function hasRole($userid,$rolename,&$error)
{
    global$api_roleprovider;
    $roleprovider=$api_roleprovider??[];
    $incfile=$roleprovider["include"]??"";
    $funcname=$roleprovider["function"]??"";
    if (empty($funcname))
    {
        $error="No role provider is configured.";
        return false;
    }
    if (file_exists($incfile))
    {
        include_once($incfile);
    }
    if (!function_exists($funcname))
    {
        $error="Role provider error. Function does not exist: $funcname";
        return false;
    }
    return $funcname($userid,$rolename,$error);
}

function registerStation($userid,$stationid,$hardwareid,$devicename,$os,$hdd,$ram,$cpu,&$error)
{
    global $sysdir;
    include_once("$sysdir/events/_include.php");
    
    $desc = [];
    $desc["stationid"] = $stationid;
    $desc["hardwareid"] = $hardwareid;
    $desc["devicename"] = $devicename;
    $desc["os"] = $os;
    $desc["hdd"] = $hdd;
    $desc["ram"] = $ram;
    $desc["cpu"] = $cpu;

    $ret = CallOnHardwareDescriptionProvided($_SERVER["REMOTE_ADDR"],$userid,$stationid,$hardwareid,$desc,$error);
    return $ret;
}

?>