<?php
//******************************************************
// Ozeki api: accountcreate.php
//
// http://localhost/ozeki/index.php?api=account&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
//   {
//    "action":"exists",
//    "userid":md5("admin@ozeki.hu")
//   }
//
// Response: 
//   Content-Type: application/json
// Response data: 
//   {
//     "status":"OK",
//     "errormessage":""
//     "accountstatus":"found"
//     "adminpublickey":""
//   }
//
// Response data: 
//   {
//     "status":"OK",
//     "errormessage":""
//     "accountstatus":"notfound"
//     "adminpublickey":""
//   }
//
// Response data: 
//   {
//     "status":"ERROR",
//     "errormessage":"..."
//     "adminpublickey":""
//   }
//******************************************************

include_once("$sysdir/authentication/users.php");

function handlerequest_account_exists($stationid,$req,&$resp,&$errormessage)
{
    global $adminpublickeypem;

    $resp["adminpublickey"] = $adminpublickeypem;

    if (!isset($req["userid"]) || !ismd5($req["userid"]))
    {
        $errormessage = "Invalid userid";
        return false;
    }

    $userid = $req["userid"];
    if (!userExists($userid))
    {
        $resp["accountstatus"] = "notfound";
        $errormessage = "";
        return true;
    } 

    $resp["accountstatus"] = "found";
    $errormessage = "";
    return true;
}

?>