<?php
include_once("$dirprefix/ozeki/sys/authentication/accountdelete.php");
//******************************************************
// Ozeki api: delete.php
//
// http://localhost/ozeki/index.php?api=account&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
//   Ozeki-User: $userhash
//   Ozeki-Signature: RSA signature of post data
// Post data: 
//    {
//        "action": "delete",
//        "userid": "9c613d4832453cbf65997912e086be80",
//        }
//
// Response: 
//   {
//	  "status":"OK",
//	  "errormessage":"",
//	}
//
//******************************************************
function handlerequest_account_delete($adminid,$req,&$resp,&$errormessage){
    if(!getreqparamstr($req,"userid",$userid,$resp,$errormessage)) return false;
    if(!isAdmin($adminid)){
        $errormessage = "Only administrators are authorized to delete users";
        return false;
    }
    if(isAdmin($userid)){
        $error = "Cannot delete admin account";
        return false;
    }
    delete_account($userid);
    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    return true;
}
?>