<?php
//******************************************************
// Ozeki api: accountcreate.php
//
// http://localhost/ozeki/index.php?api=account&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
// {
//   "action":"create",
//   "userid": md5($email),
//   "pwhash": sha512(password),
//   "fullname": "Alice Smith",
//   "rsakey": $pkencoded,
//   "aesprivatekey: $aesprivateencrypted,
//   "aessharedkey: $aessharedencrypted,
//   "registration: $regedataencrpyted,
//   "rsakey_admin: $pkencryptedwithadminpbulickey;
//   "aesprivatekey_admin: ;
//   "aessharedkey_admin: ;
//   "qualifications: string[]";->optional
// }
//
// Response: 
//   Content-Type: text/html
// Response data: 
//   {
//    "status":"ERROR",
//    "errormessage":"This e-mail account is already registered"
//   }
// Or:
//   {
//    "status":"OK",
//    "errormessage":""
//   }
//******************************************************

include_once("$sysdir/authentication/registrationcreateuser.php");
include_once("$sysdir/base/qualification.php");
include_once("$dirprefix/ozekiservices/profile/common.php");

//******************************************************
// Input validation
//******************************************************
function handlerequest_account_create($stationid,$req,&$resp,&$error)
{
    global $regdir,$adminuserid, $siteid;

    if (!isset($req["userid"]) || !ismd5($req["userid"]))
    {
        $error = "Invalid userid";
        return false;
    }
    
    $userid = $req["userid"];
    if (userExists($userid))
    {
        $error = "User already exists";
        return false;
    } 

    if (!isset($req["fullname"]) || isempty($req["fullname"]))
    {
        $error = "Invalid full name";
        return false;
    }
    $fullname = $req["fullname"];

    if (!isset($req["pwhash"]) || !issha512($req["pwhash"]))
    {
        $error = "Invalid password";
        return false;
    }
    $pwhash = $req["pwhash"];

    if (!isset($req["privatekey"]) || isempty($req["privatekey"]))
    {
        $error = "Private key not found";
        return false;
    }

    if (!isset($req["privatekey"]) || isempty($req["privatekey"]))
    {
        $error = "RSA private key not found";
        return false;
    }

    if (!isset($req["aesprivatekey"]) || isempty($req["aesprivatekey"]))
    {
        $error = "AES private key not found";
        return false;
    }

    if (!isset($req["aessharedkey"]) || isempty($req["aessharedkey"]))
    {
        $error = "AES shared key not found";
        return false;
    }

    if (!isset($req["registration"]) || isempty($req["registration"]))
    {
        $error = "Personal details not found";
        return false;
    }
    

    $userdir = "$regdir/$userid";
    if (!ozmkdir($userdir,$error))
    {
        $error = "Cannot create user directory";
        return false;
    }

    $pkfile = "$userdir/privatekey_".$pwhash.".txt";
    if (!ozsavefile($pkfile,$req["privatekey"],$error))
    {
        $error = "Cannot save user private key";
        return false;
    }

    $pubfile = "$userdir/publickey.txt";
    if (!ozsavefile($pubfile,$req["publickey"],$error))
    {
        $error = "Cannot save user public key";
        return false;
    }

    $aespkfile = "$userdir/aesprivate.txt";
    if (!ozsavefile($aespkfile,$req["aesprivatekey"],$error))
    {
        $error = "Cannot save user aes private key";
        return false;
    }

    $aesshfile = "$userdir/aesshared.txt";
    if (!ozsavefile($aesshfile,$req["aessharedkey"],$error))
    {
        $error = "Cannot save user aes shared key";
        return false;
    }

    $regfile = "$userdir/registration.txt";
    if (!ozsavefile($regfile,$req["registration"],$error))
    {
        $error = "Cannot save user registration details";
        return false;
    }

    $shareddir = "$userdir/sharedto";
    if (!ozmkdir($shareddir,$error))
    {
        $error = "Cannot create sharedto directory";
        return false;
    }

    if (isset($req["rsakey_admin"]) && !isempty($req["rsakey_admin"]))
    {
        $adminrsa = "$shareddir/$adminuserid"."_rsa.txt";
        if (!ozsavefile($adminrsa,$req["rsakey_admin"],$error))
        {
            $error = "Cannot save user rsa key for admin";
            return false;
        }
    }

    if (isset($req["aessharedkey_admin"]) && !isempty($req["aessharedkey_admin"]))
    {
        $adminaesshared = "$shareddir/$adminuserid"."_aesshared.txt";
        if (!ozsavefile($adminaesshared,$req["aessharedkey_admin"],$error))
        {
            $error = "Cannot save user aes shared key for admin";
            return false;
        }
    }

    if (isset($req["aesprivatekey_admin"]) && !isempty($req["aesprivatekey_admin"]))
    {
        $adminaesprivate = "$shareddir/$adminuserid"."_aesprivate.txt";
        if (!ozsavefile($adminaesprivate ,$req["aesprivatekey_admin"],$error))
        {
            $error = "Cannot save user aes private key for admin";
            return false;
        }
    }

    updatePublicDetails($userid,$fullname,"");
    /* if(!createProfile($userid,$mydetails,$error,$req["aessharedkey"])){
        $error = "Cannot create userprofile";
        return false;
    }
    if(!saveProfile($userid,$mydetails,$error,$req["aessharedkey"])){
        $error = "Cannot save userprofile";
        return false;
    } */

    //apply qualifications
    if (isset($req["qualifications"]) && !isempty($req["qualifications"])){
        if(!setUserQualifications($userid,$req["qualifications"],$error)){
            $error = "Cannot set user qualifications.";
            return false;
        }
    }

    $error = "";

    $resp = [];
    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    
    return true;
}
?>
