<?php
date_default_timezone_set("UTC");
header("Content-Type: application/json");

include_once("$dirprefix/ozekiservices/api/api/v2.0/account/login.php");
include_once("$dirprefix/ozekiservices/api/api/v2.0/account/loginapi.php");
include_once("$dirprefix/ozekiservices/api/api/v2.0/account/exists.php");
include_once("$dirprefix/ozekiservices/api/api/v2.0/account/create.php");
include_once("$dirprefix/ozekiservices/api/api/v2.0/account/secquestions.php");
include_once("$dirprefix/ozekiservices/api/api/v2.0/account/update.php");
include_once("$dirprefix/ozekiservices/api/api/v2.0/account/delete.php");


//******************************************************
// Load request parameters
//******************************************************
$postdata = file_get_contents('php://input');
$req = json_decode($postdata, true);
if (!isset($req["action"]))
{
    $resp["status"] = "ERROR";
    $resp["errormessage"] = "Invalid action parameter in request.";
    $resp["errordetails"] = $postdata;
    echo json_encode($resp);
    exit;
}
$action = $req["action"];
$headers=getRequestHeaders();
$stationid = (isset($headers["Ozeki-Station"])) ? $headers["Ozeki-Station"] : "";
$userid = (isset($headers["Ozeki-User"])) ? $headers["Ozeki-User"] : "";

//******************************************************
// Return response
//******************************************************

switch ($action)
{
    case"login":
        $ret = handlerequest_account_login($stationid,$req,$resp,$error);
        break;
    case"loginapi":
        $ret = handlerequest_account_login_api($stationid,$req,$resp,$error);
        break;
    case"exists":
        $ret = handlerequest_account_exists($stationid,$req,$resp,$error);
        break;
    case"create":
        $ret = handlerequest_account_create($stationid,$req,$resp,$error);
        break;
    case "setsecurityquestions":
        $ret = isValidSignedInput($userid,$stationid,$req,$action,$error) &&
        handlerequest_account_updatesecquestions($stationid,$userid,$req,$resp,$error);
        break;
    case "update":
        $ret = isValidSignedInput($userid,$stationid,$req,$action,$error) && handlerequest_user_update($userid,$stationid,$req,$resp,$error);
        break;
    case "delete":
        $ret = isValidSignedInput($userid,$stationid,$req,$action,$error) && handlerequest_account_delete($userid,$req,$resp,$error);
        break;
    default:
        $error = "Invalid action paramter";
        $ret = false;
        break;
}

if (!$ret)
{
    ozerror(__FILE__,"Account api '$action' error: $error",$resp,$errorfomatted);

    $resp["status"] = "ERROR";
    $resp["errormessage"] = "$error";
}

$resp=json_encode($resp);
echo$resp;

?>