<?php
//******************************************************
// Ozeki api: accountcreate.php
//
// http://localhost/ozeki/index.php?api=api.account.securityquestions&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
//   {"action":"api.account.securityquestions.update","userid":"f17c01af66aa70508d31d99b87976fa3","password":"qwe123","question1":"In which city did your parents meet?","answer1":"budapest","question2":"What is the name of your grandmother's dog?","answer2":"bloki"}
//
// Response: 
//   Content-Type: application/json
// Response data: 
//   {"status":"OK","errormessage":"","accountstatus":"notfound"}
//******************************************************

include_once("$sysdir/authentication/users.php");
include_once("$sysdir/authentication/secquestions.php");
include_once("$sysdir/authentication/login.inc.php");

//******************************************************
// Load the request
//******************************************************

header("Content-Type: application/json");
$postdata = file_get_contents('php://input');
$req = json_decode($postdata, true);

//******************************************************
// Create the response
//******************************************************
if (!userExists($req["userid"]))
{
    $resp["status"] = "ERROR";
    $resp["errormessage"] = "Invalid user id";
    $resp["accountstatus"] = "notfound";
    $resp["notfoundreason"] = "User has not registered.";
    $resp = json_encode($resp);
    echo $resp;
    exit;
} 

//******************************************************
// Update secuirty questions
//******************************************************
                     
if ($req["action"]=="api.account.securityquestions.update") 
{
    if (!loginUser($req["userid"],$req["password"],$userprivatekey,$userpublickey,$useraesprivate,$useraesshared,$userdetails,$error))
    {
        ozerror(__FILE__,$error,$resp,$error);
        echo json_encode($resp);
        exit;
    }

    if (!updateSecurityQuestions($req["userid"],$userprivatekey, $req["question1"],$req["answer1"],$req["question2"],$req["answer2"],$error))
    {
        ozerror(__FILE__,$error,$resp,$error);
        echo json_encode($resp);
        exit;
    }

    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    echo json_encode($resp);
    exit;
}

//******************************************************
// Download secuirty questions
//******************************************************
if ($req["action"]=="api.account.securityquestions.download") 
{
    if (!userExists($req["userid"]))
    {
        ozerror(__FILE__,"User not found.",$resp,$error);
        echo json_encode($resp);
        exit;
    }

    if (!getSecurityQuestions($req["userid"],$secquestion1,$secquestion2,$error))
    {
        ozerror(__FILE__,"Security questions not found. $error",$resp,$error);
        echo json_encode($resp);
        exit;
    }

    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    $resp["question1"] = $secquestion1;
    $resp["question2"] = $secquestion2;
    echo json_encode($resp);
    exit;
}

//******************************************************
// Reset password
//******************************************************
if ($req["action"]=="api.account.securityquestions.newpassword") 
{
    if (!userExists($req["userid"]))
    {
        ozerror(__FILE__,"User not found.",$resp,$error);
        echo json_encode($resp);
        exit;
    }

    if (!resetPassword($req["userid"],$req["answer1"],$req["answer2"],$req["newpassword"],$error))
    {
        ozerror(__FILE__,"Could not reset password. $error",$resp,$error);
        echo json_encode($resp);
        exit;
    }

    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    echo json_encode($resp);
    exit;
}

//******************************************************
// Default action
//******************************************************

$resp["status"] = "ERROR";
$resp["errormessage"] = "Invalid action";
echo json_encode($resp);
exit;

?>