<?php
//******************************************************
// Ozeki api: accountlogin.php
//
// http://localhost/ozeki/index.php?api=accountlogin&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
//   {"action":"accountstatus","userid":"d574638619cbff603bf857164c47e850","password":"password123"}
//
// Response: 
//   Content-Type: application/json
// Response data: 
//   {"status":"OK","errormessage":"","email":"admin@ozeki.hu","fullname":"Administrator","mobile":""}
//******************************************************

include_once("$sysdir/authentication/login.inc.php");
include_once("$dirprefix/ozekiservices/api/api/v1.0/login.inc.php");

//******************************************************
// Load the request
//******************************************************

header("Content-Type: application/json");
$postdata = file_get_contents('php://input');
$req = json_decode($postdata, true);

//******************************************************
// Create the response
//******************************************************
if (!isValidInput_Login($req, $error))
{
    ozerror(__FILE__,$error,$resp,$error);
    echo json_encode($resp);
    exit;
}

$country = "";
if (!loginUser($req["userid"],$req["password"],$privatekey,$publickey,$aesprivate,$aesshared,$userdetails,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    echo json_encode($resp);
    exit;
} 

if (isset($req["stationid"]) && !isempty($req["stationid"]))
{
    $station = $req["stationid"];
    if (!loginStation($req["userid"],
        $req["password"],
        $req["stationid"],
        $req["hardwareid"],
        $req["devicename"],
        $req["os"],
        $req["hdd"],
        $req["ram"],
        $req["cpu"],$stationapikey,$stationprivatekey,$error))
    {
        ozerror(__FILE__,$error,$resp,$error);
        echo json_encode($resp);
        exit;
    }
}

$resp["status"] = "OK";
$resp["errormessage"] = "";
$resp["email"] = $userdetails["email"];
$resp["fullname"] = $userdetails["fullname"];
$resp["mobile"] = $userdetails["mobile"];
if (isset($station) && !isEmpty($station))
{
    $resp["station"] = $station;
    $resp["stationapikey"] = $stationapikey;
    $resp["stationprivatekey"] = $stationprivatekey;
}
$response = json_encode($resp);
echo $response;
exit; 
?>