<?php
//******************************************************
// Ozeki api: accountcreate.php
//
// http://localhost/ozeki/index.php?api=accountexists&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
//   {"action":"accountstatus","email":"admin@ozeki.hu"}
//
// Response: 
//   Content-Type: application/json
// Response data: 
//   {"status":"OK","errormessage":"","accountstatus":"notfound"}
//******************************************************

include_once("$sysdir/authentication/users.php");

//******************************************************
// Invput validation
//******************************************************

function isValidInput_AccountExists($req,&$resp)
{
    if (!isset($req["email"]) || !isemail($req["email"]))
    {
        $resp["status"] = "Error";
        $resp["errormessage"] = "Invalid e-mail address";
        return false;
    }
      
    $resp["status"] = "OK";
    $resp["errormessage"] = "";
    return true;
}

//******************************************************
// Load the request
//******************************************************

header("Content-Type: application/json");
$postdata = file_get_contents('php://input');
$req = json_decode($postdata, true);

//******************************************************
// Create the response
//******************************************************
if (!isValidInput_AccountExists($req, $resp))
{
    $resp = json_encode($resp);
    echo $resp;
    exit;
}

$country = "";
if (!userExists(md5($req["email"])))
{
    $resp["accountstatus"] = "notfound";
    $resp["notfoundreason"] = "User has not registered.";
   
} else
{
    $resp["accountstatus"] = "found";
}

$resp = json_encode($resp);
echo $resp;
exit;
?>