<?php
//******************************************************
// Ozeki api: accountupdate.php
//
// http://localhost/ozeki/index.php?api=accountupdate&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
//  {
//   "action":"accountcreate",
//   "email":"ozeki6@ozeki.hu",
//   "fullname":"Ozeki Six",
//   "mobile":"+123456789",
//   "password":"password123"
//   }
//
// Response: 
//   Content-Type: text/html
// Response data: 
//   {"status":"ERROR","errormessage":"This e-mail account is already registered"}
// Or:
//   {"status":"OK","errormessage":""}
//******************************************************

include_once("$sysdir/authentication/registrationupateuser.php");

//******************************************************
// Input validation
//******************************************************
function isValidInput_AccountCreate($req, &$error)
{
    if (!isset($req["userid"]) || !ismd5($req["userid"]))
    {
        $error = "Invalid userid";
        return false;
    }

    if (!isset($req["email"]) || !isemail($req["email"]))
    {
        $error = "Invalid e-mail address";
        return false;
    }
    
    if (!isset($req["fullname"]) || strlen($req["fullname"])<3)
    {
        $error = "Invalid fullname";
        return false;
    }

    if (!isset($req["password"]) || !isPasswordTooShort($req["password"],$error))
    {
        $error = "Invalid current password. $error";
        return false;
    }
   
    return true;
}

//******************************************************
// Load the request
//******************************************************

header("Content-Type: application/json");
$postdata = file_get_contents('php://input');
$req = json_decode($postdata, true);

//******************************************************
// Create the response
//******************************************************

if (!isValidInput_AccountCreate($req,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    echo json_encode($resp);
    exit;
}

$country = "";
if (!updateUserRegistration($req["userid"],$req["password"],$req["email"],$req["fullname"],$req["mobile"],$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    echo json_encode($resp);
    exit;
}

$resp["status"] = "OK";
$resp["errormessage"] = "";
$response = json_encode($resp);
echo $response;
exit;
?>