<?php
//******************************************************
// Ozeki api: accountcreate.php
//
// http://localhost/ozeki/index.php?api=accountcreate&srv=api
//
// Request
//   Content-Type: application/json
//   Ozeki-Station: $stationidhash
// Post data: 
// {"action":"accountcreate","email":"ozeki6@ozeki.hu","fullname":"Ozeki Six","mobile":"+123456789","password":"password123"}
//
// Response: 
//   Content-Type: text/html
// Response data: 
//   {"status":"ERROR","errormessage":"This e-mail account is already registered"}
// Or:
//   {"status":"OK","errormessage":""}
//******************************************************

include_once("$sysdir/authentication/registrationcreateuser.php");

//******************************************************
// Input validation
//******************************************************
function isValidInput_AccountCreate($req, &$error)
{
    if (!isset($req["userid"]) || !ismd5($req["userid"]))
    {
        $error = "Invalid userid";
        return false;
    }

    if (!isset($req["email"]) || !isemail($req["email"]))
    {
        $error = "Invalid e-mail address";
        return false;
    }
    
    if (!isset($req["fullname"]) || strlen($req["fullname"])<3)
    {
        $error = "Invalid fullname";
        return false;
    }

    if (!isset($req["mobile"]) || !isvalidtelephonenumber($req["mobile"]))
    {
        $error = "Invalid phone number";
        return false;
    }
    
    if (!isset($req["password"]) || !isPasswordTooShort($req["password"],$error))
    {
        $error = "Invalid password. $error";
        return false;
    }

    return true;
}

//******************************************************
// Load the request
//******************************************************

header("Content-Type: application/json");
$postdata = file_get_contents('php://input');
$req = json_decode($postdata, true);

//******************************************************
// Create the response
//******************************************************

if (!isValidInput_AccountCreate($req,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    echo json_encode($resp);
    exit;
}

$country = "";
if (!createUser($req["userid"],$req["email"],$req["fullname"],$req["password"],$out_privatekey,$out_error,$req["mobile"],$country))
{
    ozerror(__FILE__,$out_error,$resp,$out_error);
    echo json_encode($resp);
    exit;
}

$resp["status"] = "OK";
$resp["errormessage"] = "";
$response = json_encode($resp);
echo $response;
exit;
?>