<?php
//**********************************************************
// Load config
//**********************************************************
$serviceconfig = "$configdir/aigate.php";
if (file_exists($serviceconfig))
    include_once($serviceconfig);

global $aigate_logdir;
if (isset($aigate_logdir) && $aigate_logdir != "")
    return;

//**********************************************************
// Create default config
//**********************************************************
$default_aigate_logdir = "$datadir/services/aigate/logs";

$defaultconfig = <<<DEFCONF
//**********************************************************
// AI gateway client
//**********************************************************
\$aigate_useragent = 'OZEKI-AI-Gateway/1.0';
\$aigate_useragent_passthru = true;

//**********************************************************
// AI gateway logging
//**********************************************************
\$aigate_logdir = "$default_aigate_logdir";
\$aigate_logging_blurapikeys = true;

//**********************************************************
// AI gateway limitations
//**********************************************************
\$aigate_request_maxsize = 0; //0 means not limited. Common value: 10485760 (10MB)
\$aigate_request_timeout = 900; //900sec is 15 minutes
DEFCONF;

addSectionToServiceConfig($defaultconfig,"aigate");
include_once($serviceconfig);
?>