<?php
//******************************************************
// Apache config update 
//
// http://localhost/ozeki/index.php?srv=aigate&api=servercontrol
//
//******************************************************
include_once("$dirprefix/ozekiservices/aigate/api/servercontrol/servercontrol_apacheconfig.php");
include_once("$dirprefix/ozekiservices/aigate/api/servercontrol/servercontrol_phpconfig.php");

//******************************************************
// Load request
//******************************************************
header('Content-Type: application/json');

if (!isValidSignedInput($userid,$stationid,$req,$action,$error))
{
    ozerror(__FILE__,$error,$resp,$error);
    $resp=json_encode($resp);
    echo $resp;
    http_response_code(200);
    exit;
}

if (!isDecisionMaker($userid))
{
    ozerror(__FILE__,"Only admin users can control the server. $userid is not listed as admin in admin.php in ozekiconfig.: $action",$resp,$error);
    $resp=json_encode($resp);
    echo $resp;
    exit;
}

//******************************************************
// Config
//******************************************************

date_default_timezone_set('UTC');

//******************************************************
// Return response
//******************************************************

switch ($action)
{
    case"apacheconfig":
        handlerequest_apacheconfig($userid,$req,$resp);
        break;
    case"phpconfig":
        handlerequest_phpconfig($userid,$req,$resp);
        break;
    default:
        ozerror(__FILE__,"Invalid fileserver action: $action",$resp,$error);
        break;
}

$resp=json_encode($resp);
echo $resp;

?>