<?php

function proxyLogTransaction($request, $response, $apiuserid, $selectedprovider, $duration, $error = null) {

    global $aigate_logdir,$aigate_logging_blurapikeys;
    $logBaseDir = "$aigate_logdir/proxy";
    error_log("proxy.php: Log dir: $logBaseDir");

    // Create base log directory if it doesn't exist
    if (!is_dir($logBaseDir)) {
        mkdir($logBaseDir, 0755, true);
    }
    
    // Create daily directory
    $dateDirectory = date('Ymd');
    $dailyLogDir = $logBaseDir . '/' . $dateDirectory;
    
    if (!is_dir($dailyLogDir)) {
        mkdir($dailyLogDir, 0755, true);
    }
    error_log("Logging transaction to ".$dailyLogDir);
    
    //Prepare variables
    $timeoflog = date('His');
    $transactionid = $timeoflog."-".substr(md5(uniqid(mt_rand(), true)), 0, 8);
    $timestamp = date('Y-m-d H:i:s');
    $duration = round($duration * 1000, 2);
    
    if ($aigate_logging_blurapikeys) {
        if (isset($request['headers']['Authorization'])) $request['headers']['Authorization'] = "Ozeki protected";
        if (isset($request['headers']['authorization'])) $request['headers']['authorization'] = "Ozeki protected";
    }
    if (isset($selectedprovider["id"])) $providerid = $selectedprovider["id"]; else $providerid="";
    
    // Write transaction file
    $logEntry = [
        'transactionid' => $transactionid,
        'timestamp' => $timestamp,
        'userid' => $apiuserid,
        'duration_ms' => $duration,
        'request' => $request,
        'response' => $response,
        'error' => $error
    ];
    
    $timePrefix = date('His');
    $logFilePath =  "{$dailyLogDir}/{$transactionid}.json";
    $jsonContent = json_encode($logEntry, JSON_PRETTY_PRINT);
    file_put_contents($logFilePath, $jsonContent, LOCK_EX);
    
    // Write index files
    $indexEntry = [
        'timestamp' => $timestamp,
        'trasactionid' => $transactionid,
        'url' => $request['url'] ?? '-',
        'userid' => $apiuserid,
        'client' => $request['client'] ?? 'unknown',
        'http_code' => $response['http_code'] ?? null,
        'duration_ms' => $duration,
    ];
   
    // Write daily log
    $indexLine = json_encode($indexEntry);
    proxyWriteLogLines($dailyLogDir,$providerid,$apiuserid,$indexLine);
    
    // Write monthly log
    $monthlyLogDir = $logBaseDir . '/' . date('Ym');
    proxyWriteLogLines($monthlyLogDir,$providerid,$apiuserid,$indexLine);

    
}

function proxyWriteLogLines($dir,$providerid,$apiuserid,$indexLine)
{
    //Create dir
    if (!is_dir($dir)) {
        mkdir($dir, 0755, true);
    }

    // Append to main log
    $indexFile =  $dir . '/index.jplog';
    file_put_contents($indexFile, $indexLine . "\n", FILE_APPEND | LOCK_EX);

    // Append to user log
     if ($apiuserid != "" ) 
     {
         $indexFile = $dir . '/index-u-'.$apiuserid.'.jplog';
         file_put_contents($indexFile, $indexLine . "\n", FILE_APPEND | LOCK_EX);
     }

}

function proxyGetClientIp() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    }

    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        // X-Forwarded-For can contain multiple IPs — take the first one
        $ipList = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        return trim($ipList[0]);
    }

    return $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
}

function proxyRequestChanges($originalRequest,$forwardedRequest)
{
    $ret = [];
    foreach($originalRequest as $key=>$value)
    {
        if ($value==$forwardedRequest[$key]) continue;
        $ret[$key] = $forwardedRequest[$key];
    }
    return $ret;
}

/**
 * Strip the HTTP status line and turn the remaining headers into an array.
 *  – "Key: value"  →  ['Key' => 'value']
 *  – multi-line headers (folded with leading space/tab) are concatenated
 *
 * @param  string $raw   Complete HTTP response text
 * @return array         Associative array of headers
 */
function proxyParseResponseHeaders(string $raw): array
{
    $headers = [];

    /* 1. drop the first line (everything up to the first \n) */
    $raw = substr($raw, strpos($raw, "\n") + 1);

    /* 2. normalise line endings and unfold continuation lines */
    $raw = str_replace(["\r\n", "\r"], "\n", $raw);
    $raw = preg_replace('/\n[ \t]+/', ' ', $raw);   // RFC 7230 folding

    /* 3. build the array */
    foreach (explode("\n", trim($raw)) as $line) {
        $colon = strpos($line, ':');
        if ($colon === false) {          // malformed, skip
            continue;
        }
        $key   = trim(substr($line, 0, $colon));
        $value = trim(substr($line, $colon + 1));
        $headers[$key] = $value;
    }

    return $headers;
}

?>