<?php
/**
 * Handle request to list provider names and IDs
 *
 * @param string $userid
 * @param array  $req   Request data
 * @param array  &$resp Response data (by reference)
 * @return bool
 */

function handlerequest_listnames($userid, $req, &$resp)
{
    $error = "";

    global $datadir;
    $providersdir = "$datadir/services/aigate/providers";

    // Check if providers directory exists
    if (!is_dir($providersdir)) {
        $error = "Providers directory not found: $providersdir";
        ozerror(__FILE__, $error, $resp, $error);
        $resp["status"] = "ERROR";
        $resp["errormessage"] = $error;
        return false;
    }

    $providers = array();

    // Get all subdirectories in providers folder
    $subdirs = scandir($providersdir);
    foreach ($subdirs as $subdir) {
        // Skip . and .. directories
        if ($subdir === '.' || $subdir === '..') {
            continue;
        }

        $providerpath = "$providersdir/$subdir";
        $contentfile = "$providerpath/content.dat";

        // Check if it's a directory and contains content.dat
        if (is_dir($providerpath) && file_exists($contentfile)) {
            $providerdata = array();
            $fileerror = "";

            if (ozreadjson($contentfile, $providerdata, $fileerror)) {
                // Extract id and name fields
                $id = isset($providerdata["id"]) ? $providerdata["id"] : $subdir;
                $name = isset($providerdata["name"]) ? $providerdata["name"] : "";
               
                $providers[$id] =  $name;
            } else {
                $error .= "Could not read provider content file: $subdir. $fileerror. ";
               
            }
        }
    }

    // Build response
    $resp["status"] = "OK";
    $resp["errormessage"] = $error;
    $resp["providers"] = $providers;

    return true;
}

/*
// Input
{
    action: 'listnames'
};

// Response
{
    status: "OK",
    errormessage": "",
    providers: {
        "9feae991919ef33fdf5acbfa5b604af3":"a1b2c3d4e5f6...",
        "YVWAFPWG":"Ozeki video server"
        }
    }
}
*/
?>
