<?php

function parseStreamingData($requestData, $streamingData) {
    $lines = explode("\n", $streamingData);
    $totalChunks = 0;
    
    foreach ($lines as $line) {
        $line = trim($line);
        
        // Skip empty lines and comments
        if (empty($line) || strpos($line, ':') === 0) {
            continue;
        }
        
        // Parse Server-Sent Events format
        if (strpos($line, 'data: ') === 0) {
            $dataStr = substr($line, 6); // Remove 'data: ' prefix
            
            // Skip [DONE] marker
            if ($dataStr === '[DONE]') {
                continue;
            }
            
            // Parse JSON data
            $jsonData = json_decode($dataStr, true);
            if ($jsonData) {
                $totalChunks++;
            }
        }
    }
    
    // Extract aggregated content, finish reason, and usage
    $totalContent = '';
    $finishReason = null;
    $usage = null;
    $jsonDataParts = [];
    $resp=[];
    
    foreach ($lines as $line) {
        $line = trim($line);
        
        if (strpos($line, 'data: ') !== 0) continue;

        $dataStr = substr($line, 6);
        if ($dataStr === '[DONE]') continue;
        
        
        $jsonData = json_decode($dataStr, true);
        if ($jsonData) {
            $jsonDataParts[] = $jsonData;

            foreach ($jsonData as $key=>$value)
            {
                if ($key == "choices")
                {
                    for($x=0;$x<count($value);$x++)
                    {
                        $choice = $value[$x];
                        foreach($choice as $choicekey => $choicevalue)
                        {
                            if ($choicekey=="delta")
                            {
                                foreach($choicevalue as $cvkey => $cvvalue)
                                {
                                    if ($cvkey == "content")
                                    {
                                        if (!isset($resp["choices"][$x]["message"]["content"])) $resp["choices"][$x]["message"]["content"] = "";
                                        $resp["choices"][$x]["message"]["content"] .= $cvvalue;
                                    } 
                                    elseif ($cvkey == "reasoning_content")
                                    {
                                        if (!isset($resp["choices"][$x]["message"]["reasoning_content"])) $resp["choices"][$x]["message"]["reasoning_content"] = "";
                                        $resp["choices"][$x]["message"]["reasoning_content"] .= $cvvalue;
                                    }
                                    else
                                    {
                                        $resp["choices"][$x]["message"][$cvkey] = $cvvalue;
                                    }
                                } 
                            } else {
                                $resp["choices"][$x][$choicekey] = $choicevalue; 
                            }
                        }
                    }

                    continue;
                } 
                $resp[$key] = $value;
            }

            
            // Extract content from delta
            if (isset($jsonData['choices'][0]['delta']['content'])) {
                $totalContent .= $jsonData['choices'][0]['delta']['content'];
            }
            
            // Extract finish reason
            if (isset($jsonData['choices'][0]['finish_reason']) && $jsonData['choices'][0]['finish_reason']) {
                $finishReason = $jsonData['choices'][0]['finish_reason'];
            }
            
            // Extract usage info (usually in final chunk)
            if (isset($jsonData['usage'])) {
                $usage = $jsonData['usage'];
            }
            
        }
        
    }

    $resp['chunks'] = $jsonDataParts;
    $resp['chunk_count'] = count($jsonDataParts);
    if ($usage!=null) {
        $resp['usage'] = $usage;
    } 
    else
    {
        require_once __DIR__ . '/openai_inc_logger_tokenizer.php';

        if (isset($requestData->messages)) {
            $requestText = assembleRequestText($requestData->messages);
            $resp['usage']['prompt_tokens'] = tokenize_llama3($requestText, $tokenlist);
            $resp['usage']['completion_tokens'] = tokenize_llama3($totalContent, $tokenlist);
            $resp['usage']['total_tokens'] = $resp['usage']['prompt_tokens']+$resp['usage']['completion_tokens'];
            $resp['usage']['calculation'] = "estimate";
        }
    }
    return $resp;

}

function assembleRequestText($messages): string {
    $result = '';
    foreach ($messages as $value) 
    {
        if (isset($value->content) && is_string($value->content)) {
            $result .= $value->content . ';';
            continue;
        }

        if (is_array($value->content))
        {
            foreach($value->content as $entry)
            {
                if (isset($entry->text) && is_string($entry->text)) {
                    $result .= $entry->content;
                }
            }
        }
    }

    return $result;
    
}

?>
