<?php
$debugRouting = false;

function routingFindProvider($resolveGroup,$userId,$apiKeyId,$modelName,&$selectedprovider,&$selectedroute,&$selectedmodelname,&$error)
{
    global $debugRouting;
    if ($debugRouting) error_log("gateway_routing.php: Find provider request. UserID: $userId. API key: $apiKeyId. Model name: $modelName");

    $selectedmodelname = $modelName;
    // find provider 
    if (!findProviderById($selectedprovider) &&
        !routingFindProviderByRoute($userId,$apiKeyId,$selectedprovider,$selectedroute,$error)) 
    {
        if ($debugRouting) error_log("gateway_routing.php: Provider not found by ID or route. $error");
        return false;
    }

    if (!$resolveGroup)
    {
        if ($debugRouting) error_log("gateway_routing.php: Group resolution not requested. Selected route returned: " . $selectedprovider["name"]);
        return true;
    }
    
    if ($debugRouting) error_log("gateway_routing.php: Selected route returned: " . $selectedprovider["name"]);

    // Check if the selected provider is a Provider group
    if (isset($selectedprovider["providerType"]) && $selectedprovider["providerType"] == "Provider group") {
        if ($debugRouting) error_log("gateway_routing.php: Provider group detected: " . $selectedprovider["name"]);
        
        // Check if availableProviders exists
        if (!isset($selectedprovider["availableProviders"]) || !is_array($selectedprovider["availableProviders"])) {
            $error = "Provider group has no availableProviders array";
            if ($debugRouting) error_log("gateway_routing.php: ".$error);
            return false;
        }
        
        // Get the model name from parameter
        if (empty($modelName)) {
            $error = "No model specified in request";
            error_log("gateway_routing.php: ".$error);
            $modelName = "undefined";
        }
        if ($debugRouting) error_log("gateway_routing.php: "."Finding provider for model name: $modelName");
        
        // Find the prefix (provider name) by looking for the first "/" or "-" pattern
        // The format is "ProviderName-ModelName" where ProviderName has spaces replaced by -
        $prefix = "";
        $actualModelName = "";
        
        // Try to find the provider by matching prefix in availableProviders
        global $datadir;
        $providerDir = "$datadir/services/aigate/providers";
        
        foreach ($selectedprovider["availableProviders"] as $providerid) {
            $providerdetails = "$providerDir/$providerid/content.dat";
            
            if (!ozreadjson($providerdetails, $provider, $error)) {
                if ($debugRouting) error_log("AI model provider not found while looking for id: $providerid. $error");
                continue;
            }
            
            // Create prefix from provider name (replace spaces with -)
            $providerPrefix = str_replace(' ', '-', $provider["name"]);
            
            // Check if the model name starts with this prefix
            if ($modelName == "undefined" || 
                strpos($modelName, $providerPrefix . "/") === 0 ||
                strpos($modelName, $providerPrefix . "-") === 0) 
            {
                if ($debugRouting) error_log("gateway_routing.php: "."Found matching provider: " . $provider["name"] . " (id: $providerid)");
                
                // Extract the actual model name by removing the prefix
                $prefixLen = strlen($providerPrefix) + 1; // +1 for the separator (/ or -)
                $actualModelName = substr($modelName, $prefixLen);
                
                if ($debugRouting) error_log("gateway_routing.php: "."Extracted actual model name: $actualModelName");
                
                // Update selectedmodelname output parameter
                $selectedmodelname = $actualModelName;
                
                // Update selectedprovider to the actual provider
                $selectedprovider = $provider;
                
                if ($debugRouting) error_log("gateway_routing.php: "."Selected provider updated to: " . $selectedprovider["name"]);
                return true;
            }
        }
        
        // If we get here, no matching provider was found
        $error = "No provider found for model: $modelName";
        if ($debugRouting) error_log($error);
        return false;
    }
    
    return true;
}

function findProviderById(&$selectedprovider)
{
    global $ozekiAIProviderID,$datadir;
    if (!isset($ozekiAIProviderID)) return false;
    $providerdetails = "$datadir/services/aigate/providers/$ozekiAIProviderID/content.dat";
    if (!ozreadjson($providerdetails,$selectedprovider,$error)) return false;
    error_log("Provider found by id: $ozekiAIProviderID");
    return true;
}

function routingFindProviderByRoute($userId,$apiKeyId,&$selectedprovider,&$selectedroute,&$error)
{
    global $datadir;
    $providerDir = "$datadir/services/aigate/providers";
    if (!routingFindRoute($userId,$apiKeyId,$selectedroute,$error)) return false;
    if ($selectedroute["aiprovider_id"]=="ANY")
    {
        if (!ozlsdir($providerDir,$files,$dirs,$error)) 
        {
            $error = "No AI model providers are installed. $error";
            return false;
        }
        $providerid = $dirs[0];
    }

    $providerid = $selectedroute["aiprovider_id"];
    $providerdetails = "$providerDir/$providerid/content.dat";

    if (!ozreadjson($providerdetails,$selectedprovider,$error))
    {
        $error = "AI model provider not found while looking for id: $providerid. $error";
        return false;
    }

    return true;
}

function routingFindRoute($userId,$apiKeyId,&$selectedroute,&$error)
{
    if (!routingLoadRoutes($routes,$error)) return false;
    foreach($routes as $route)
    {
        if (!routingRouteMatches($userId,$apiKeyId,$route)) continue;

        $selectedroute = $route;
        $error = "";
        return true;
    }
    $error = "No matching route found.";
    return false;
}


function routingLoadRoutes(&$routes,&$error) {
    global $datadir;
    $routes = [];
    $routeDir = "$datadir/services/aigate/routes";
    if (!ozlsdir($routeDir,$files,$dirs,$error)) 
    {
        $error = "Cannot load routes. $error";
        return false;
    }
    foreach($dirs as $dir)
    {
        $routefile = $routeDir."/".$dir."/content.dat";
        if (!ozreadjson($routefile,$route,$error)) continue;
        $routes[] = $route;
    }
    
    if (count($routes)==0)
    {
        $error = "Cannot load routes. No routes found.";
        return false;
    }

    usort($routes, fn($a, $b) => $a['order'] <=> $b['order']);
    return true;
}

function routingRouteMatches($userId,$apiKeyId,$route)
{
    if ($route["aiuser_id"]=="") $route["aiuser_id"] = "ANY";
    if (($route["aiuser_id"]!=$userId) && ($route["aiuser_id"]!="ANY")) return false;

    if ($route["apikey_id"]=="") $route["apikey_id"] = "ANY";
    if (($route["apikey_id"] != $apiKeyId) && ($route["apikey_id"] != "ANY")) return false;

    return true;
}

function fixapiurl($selectedprovider)
{
    switch (strtolower($selectedprovider["providerType"]))
    {
        case 'anthropic':
            return fixapiurlanthropic($selectedprovider["apiUrl"]);
        case 'openai compatible':
        default:
            return fixapiurlopenaicompatible($selectedprovider["apiUrl"]);
    }
}

function fixapiurlopenaicompatible(string $url): string
{
    // 1. Trim dangling slashes and spaces.
    $url = rtrim(trim($url), '/');

    // 2. Already contains the completions segment?  Keep it.
    if (str_contains($url, '/chat/completions')) {
        return $url;
    }

    // 3. Find the LAST occurrence of “/v1” (case-insensitive).
    $pos = strripos($url, '/v1');
    if ($pos !== false) {
        // Strip everything after that “/v1” and append the required suffix.
        $newurl = substr($url, 0, $pos) . '/v1/chat/completions';
        return $newurl;
    }

    // 4. Fallback: bolt the segment on.
    $aurl = $url . '/v1/chat/completions';
    return $aurl;
}

function fixapiurlanthropic(string $url): string
{
    // 1. Trim dangling slashes and spaces.
    $url = rtrim(trim($url), '/');

    // 2. Already contains the messages segment?  Keep it.
    if (str_contains($url, '/messages')) {
        return $url;
    }

    // 3. Find the LAST occurrence of "/v1" (case-insensitive).
    $pos = strripos($url, '/v1');
    if ($pos !== false) {
        // Strip everything after that "/v1" and append the required suffix.
        $newurl = substr($url, 0, $pos) . '/v1/messages';
        return $newurl;
    }

    // 4. Fallback: bolt the segment on.
    $aurl = $url . '/v1/messages';
    return $aurl;
}

function routingDetermineModel($selectedprovider,$requestedModel)
{
    if (isset($selectedprovider["allowOtherModels"]) && $selectedprovider["allowOtherModels"] &&
    isset($selectedprovider["allowAllModelsOffered"]) &&  $selectedprovider["allowAllModelsOffered"])
    {
        return $requestedModel;
    }

    if (isset($selectedprovider["allowOtherModels"]) && $selectedprovider["allowOtherModels"] &&
       (!isset($selectedprovider["allowAllModelsOffered"]) ||  !$selectedprovider["allowAllModelsOffered"]) &&
       isset($selectedprovider["allowedModels"]) && 
       is_array($selectedprovider["allowedModels"]) && 
       in_array($requestedModel,$selectedprovider["allowedModels"])
       )
    {
        return $requestedModel;
    }

    return $selectedprovider["modelName"];
}

?>
