<?php
include_once("$servicesdir/aigate/api/gateway/openai/openai_inc_logger_stream.php");

$inputTransformer = function(object $input) {
    $isStreaming = $input->stream ?? false;
    if ($isStreaming) {
        if (!isset($input->stream_options)) {
            $input->stream_options = new stdClass();
        }
        $input->stream_options->include_usage = true;
    }
    return $input;
};

$responderDefault = function(string $responseStr) {
    echo $responseStr;
    flush();
    return $responseStr;
};

$responderStreaming = function(string $responseStr) {
    //global $debugForward;
    //if ($debugForward) error_log("gateway_inc_post.php: Wrinting chunk: ".$responseStr);
    echo $responseStr;
    flush();
    return $responseStr;
};

$responderError = function(string $errorMessage) {
    global $debug;
    if ($debug) error_log("gateway_reqhandler_openai.php: $errorMessage");
    http_response_code(400);
    echo json_encode(['error' => $errorMessage]);
    flush();
    exit;
};

$responderErrorStreaming = function(string $errorMessage) {
    global $debug;
    if ($debug) error_log("gateway_reqhandler_openai.php: $errorMessage");
    echo "data: " . json_encode(['error' => $errorMessage]) . "\n\n";
    flush();
    exit;
};

$streamingDataParser = function(object $requestData, string $streamingData) {
    $requestDataArr = json_decode(json_encode($requestData), true);
    return parseStreamingData($requestData, $streamingData);
}
?>