<?php
$debugModify=true;

function modifyRequest(&$request,$route)
{
    foreach($route["request_modifier"] as $modifier)
    {
        modifyRequestWithModifier($request,$modifier);
    }
}

function modifyRequestWithModifier(&$request,$modifier)
{
    global $debugModify;

    $property = $modifier["property"];
    $match = $modifier["match"];
    $replace = $modifier["replace"];
    $inject_if_not_present = $modifier["inject_if_not_present"];

    $found = false;
    modifyRequestWithModifierRecursive($request,$modifier,$property,$match,$replace,$found);
    if (!$found && $inject_if_not_present) {
        if ($debugModify) error_log("gateway_reqhandler_modifier.php, Adding property: $property: $replace");
        $request->$property =  convertToType("string", $replace);
    }
}


function modifyRequestWithModifierRecursive(&$request,$modifier,$property,$match,$replace,&$found)
{
    global $debugModify;
    //error_log("gateway_reqhandler_modifier.php: looking for property: $property");

    if (is_object($request)) {
        if (property_exists($request, $property)) {
            error_log("gateway_reqhandler_modifier.php: Examining property: $property");
            $found = true;
            $value = $request->$property;
            $originalType  = gettype($value);

            
            if (str_starts_with($match, "/")) {
                //Regexp replace, works for strings and objects
                $result = @preg_replace($match, $replace, $value);
                if ($result === null) {
                    if ($debugModify) error_log("gateway_reqhandler_modifier.php: Invalid regex pattern in modifyRequestWithModifier: " . $match);
                } else {
                    if ($debugModify) error_log("gateway_reqhandler_modifier.php: Replacing property: $property: $replace");
                    $request->$property =  convertToType($originalType,$result);
                }
            } 
            else 
            {
                //Standard value replace keeping original type in the request
                if ($debugModify) error_log("gateway_reqhandler_modifier.php: Replacing property: $property; with value: $replace, type: $originalType");
                $result = convertToType($originalType,$replace);
                $request->$property = $result;
            }
         
        }
        foreach (get_object_vars($request) as $key => $value) {
            if (is_object($value) || is_array($value)) {
                modifyRequestWithModifierRecursive($request->$key,$modifier,$property,$match,$replace,$found);
            }
        }
    } else if (is_array($request)) {
        foreach ($request as $key => $value) {
            if (is_object($value) || is_array($value)) {
                modifyRequestWithModifierRecursive($request[$key],$modifier,$property,$match,$replace,$found);
            }
        }
    }
}

function convertToType($type, $value)
{
    if (is_string($value) && strlen($value) > 2 && $value[0] === '{' && $value[strlen($value) - 1] === '}') {
        $decoded = json_decode($value);
        if ($decoded !== null) {
            return $decoded;
        }
    }

    switch ($type) {
    case 'integer':
        $value = (int) $value;
        break;
    case 'double':
        $value = (float) $value;
        break;
    case 'boolean':
        $value = filter_var($value, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE) ?? $originalValue;
        break;
    case 'NULL':
        $value = null;
        break;
    case 'string':
        $value = (string) $value;
        break;
    }
    return $value;
}
?>