<?php
$debugForward = true;

// Verify POST data
if (empty($input)) 
    $responderError('Empty request body');
   
// Parse JSON request
$requestData = json_decode($input, false);
if (json_last_error() !== JSON_ERROR_NONE)
    $responderError('Invalid JSON: ' . json_last_error_msg());

// Find the provider
$inputmodel = $requestData->model ?? null;
if (!routingFindProvider(true, $apiuserid,$apikeyid,$inputmodel,$selectedprovider,$selectedroute,$selectedmodelname,$error))
    $responderError('Could not find requested AI Model Provider. '.$error);

$selectedrouteid = $selectedroute["id"];
$requestData->model = $selectedmodelname;

if (strtolower($inputFormat) === 'anthropic' && strtolower($selectedprovider['providerType']) === 'openai compatible')
{
    include_once("$servicesdir/aigate/api/gateway/gateway_reqhandler_anthropic_to_openai.php");
}

//fixme error log warning
$requestData = $inputTransformer($requestData);

// Modify the request
error_log("gateway_inc_post.php, Using route: ".json_encode($selectedroute));
if (isset($selectedroute["request_modifier"]))
{
    error_log("gateway_inc_post.php, Applying request modifiers: ".json_encode($selectedroute["request_modifier"]));
    include_once("$servicesdir/aigate/api/gateway/gateway_reqhandler_modifier.php");
    modifyRequest($requestData,$selectedroute);
}

// Start timing
$startTime = microtime(true);

// Request validation
if ($aigate_request_maxsize>0 && strlen($input) > $aigate_request_maxsize) 
     $responderError('Request too large. Maximum size is ' . $aigate_request_maxsize . ' bytes');

// Check if streaming is requested and enabled
$isStreaming = $requestData->stream ?? false;

$apiUrl = fixapiurl($selectedprovider);
$apiKey = $selectedprovider["apiKey"];

// Validate API key
if (!$apiKey) 
    $responderError('API key not configured.');

if ($debugForward) error_log("gateway_inc_post.php: Forwarding AI request to $apiUrl.");

// Resolve model name 
$originalRequestData = $requestData;

$model = routingDetermineModel($selectedprovider,$selectedmodelname);
if ($debugForward) error_log("gateway_inc_post.php: Using model ".$model);
$requestData->model = $model;

$postData = json_encode($requestData);
 
// Prepare cURL request
$ch = curl_init($apiUrl);

// Set cURL options
$curlOptions = [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $postData,
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/json'
    ],
    CURLOPT_TIMEOUT => $aigate_request_timeout,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_USERAGENT => 'OZEKI-AI-Gateway/1.0'
];

// Add authorization header if API key is available
if ($apiKey) {
    $curlOptions[CURLOPT_HTTPHEADER][] = 'Authorization: Bearer ' . $apiKey;
}

// Variable to collect streaming data
$streamingHeader = '';
$streamingData = '';
$streamingDataTransformed = '';
$forwardtoclient = false;

if ($isStreaming) {
    if ($debugForward) error_log("gateway_inc_post.php: This is a streaming request.");
    // Streaming-specific options
    $curlOptions[CURLOPT_RETURNTRANSFER] = false;
    $curlOptions[CURLOPT_HEADER] = true;
    $curlOptions[CURLOPT_WRITEFUNCTION] = function($ch, $data) use (&$streamingData, &$streamingDataTransformed, &$streamingHeader, &$forwardtoclient, $responderStreaming) 
    {
        $dataTransformed = '';

        // Collect streaming data for logging
        $streamingData .= $data;
        if ($debugForward) error_log("gateway_inc_post.php: Chunk received: ".$data);

        // Collect header
        if (!$forwardtoclient) {
             $divlen=4;
             $pos = strpos($streamingData, "\r\n\r\n");
             if ($pos === false) {
                $divlen=2;
                $pos = strpos($streamingData, "\n\n");
             }
             if ($pos !== false) {
                $forwardtoclient = true;
                $streamingHeader = substr($streamingData, 0,$pos);
                $streamingData = substr($streamingData, $pos + $divlen);

                //Responder writes data to ourput
                $dataTransformed .= $responderStreaming($streamingData);

                $streamingDataTransformed .= $dataTransformed;
                return strlen($data);
             } 
             return strlen($data);
        }
       
        // Return data to client
        $dataTransformed = $responderStreaming($data);
        $streamingDataTransformed .= $dataTransformed;
        if (ob_get_level() > 0) {
            ob_flush();
        }
        return strlen($data);
    };
} else {
    if ($debugForward) error_log("gateway_inc_post.php: This is a non-streaming request.");
    // Non-streaming
    $curlOptions[CURLOPT_RETURNTRANSFER] = true;
    $curlOptions[CURLOPT_HEADER] = true;
}

curl_setopt_array($ch, $curlOptions);

// Log the request
if (!function_exists('getallheaders')) {
    function getallheaders() {
        $headers = [];
        foreach ($_SERVER as $name => $value) {
            if (strpos($name, 'HTTP_') === 0) {
                $key = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($name, 5)))));
                $headers[$key] = $value;
            }
        }
        return $headers;
    }
}

$forwarded = requestChanges((array)$originalRequestData, (array)$requestData);
$forwarded["url"] = $apiUrl; 
$forwarded['model'] = $model;

$logRequest = [
    'client' => getClientIp(),
    'useragent' => $_SERVER['HTTP_USER_AGENT'],
    'method' => 'POST',
    'headers' => getallheaders(),
    'data' => json_decode(json_encode($originalRequestData), true),//fixme
    //'data_transformed' => json_decode(json_encode($requestData), true),//fixme
    'forwarded' => $forwarded
];


if ($isStreaming) {
    if ($debugForward) error_log("gateway_inc_post.php: Executing streaming request.");
    // Set headers for streaming response
    header('Cache-Control: no-cache');
    header('Connection: keep-alive');
    header('Content-Type: text/event-stream');
    header('X-Accel-Buffering: no'); // Disable nginx buffering
    
    // Execute streaming request
    $streamResult = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    $duration = microtime(true) - $startTime;
    curl_close($ch);
    
    // Parse streaming data for logging (body only)
    $streamingResponse = $streamingDataParser($requestData,$streamingData);//fixme
    unset($streamingResponse["chunks"]);

    // Log streaming transaction
    $logResponse = [
        'http_code' => $httpCode,
        'stream' => true,
        'headers' => parseRsponseHeaders($streamingHeader),
        'data' => $streamingResponse,
        //'data_transformed' => $streamingDataTransformed,//fixme
    ];
    if ($debugForward) error_log("gateway_inc_post.php: Response streaming data: ".json_encode($streamingResponse));
    
    if ($curlError) {
        if ($debugForward) error_log("gateway_inc_post.php: Error during streaming request. $curlError");
        logTransaction($logRequest, $logResponse, $apiuserid, $apikeyid, $selectedprovider,$selectedrouteid, $duration, $curlError);
        // Send error as SSE
        $responderErrorStreaming('Failed to connect to API. ' . $curlError);
        flush();
    } else {
        if ($debugForward) error_log("gateway_inc_post.php: Login transaction. $curlError");
        logTransaction($logRequest, $logResponse, $apiuserid, $apikeyid, $selectedprovider,$selectedrouteid, $duration);
    }
    
} else {
    if ($debugForward) error_log("gateway_inc_post.php: Executing non-streaming request.");
    // Non-streaming request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $curlError = curl_error($ch);
    curl_close($ch);

    // Calculate duration
    $duration = microtime(true) - $startTime;

    $responseHeaders = substr($response, 0, $headerSize);
    $response = substr($response, $headerSize); 
    
    // Parse response and transform to OpenAI format
    $responseData = json_decode($response,true);
    
    $logResponse = [
        'http_code' => $httpCode,
        'stream' => false,
        'headers' => $responseHeaders,
        'data' => $responseData,
    ];
    
    if ($curlError) {
        logTransaction($logRequest, $logResponse, $apiuserid, $apikeyid, $selectedprovider,$selectedrouteid, $duration, $curlError);
        http_response_code(500);
        $responderError('Failed to connect to API.' . $curlError);
        exit;
    }
    
    // Set response headers
    http_response_code($httpCode);
    
    // Return the OpenAI-compatible response
    $responseDataTransformed = $responderDefault($response);
    $logResponse['data_transformed'] = json_decode($responseDataTransformed,true);

    // Log successful transaction
    logTransaction($logRequest, $logResponse, $apiuserid, $apikeyid, $selectedprovider,$selectedrouteid, $duration);
}
?>