<?php

function downloadFromUrl($url,$apiKey,&$responseString,&$responseHttpCode, &$error)
{
    global $aigate_logdir, $aigate_useragent, $aigate_useragent_passthru, 
    $apiuserid, $apikeyid, $selectedprovider, $selectedrouteid, $aigate_request_timeout,$debugModelList;

    if ($debugModelList) error_log("gateway_inc_get_models.php: Downloading from URL '$url' with API Key: '$apiKey'");

    $ch = curl_init($url);

    if ($aigate_useragent_passthru)
    {
        $ua = $_SERVER['HTTP_USER_AGENT'];
    } else 
    {
        $ua = $aigate_useragent;
    }

    $curlOptions = [
        CURLOPT_HTTPGET => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/json'
        ],
        CURLOPT_TIMEOUT => $aigate_request_timeout,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_USERAGENT => $ua,
        CURLOPT_HEADER => true,
        CURLOPT_RETURNTRANSFER => true,
    ];

    // Add authorization header if API key is available
    if ($apiKey) {
        $curlOptions[CURLOPT_HTTPHEADER][] = 'Authorization: Bearer ' . $apiKey;
    }

    // Setup cURL
    curl_setopt_array($ch, $curlOptions);

    $forwarded["url"] = $url;
    $forwarded["useragent"] = $ua; 

    $logRequest = [
        'client' => getClientIp(),
        'useragent' => $_SERVER['HTTP_USER_AGENT'],
        'method' => 'GET',
        'url' => $url,
        'headers' => $curlOptions[CURLOPT_HTTPHEADER],
        'request' => "",
        'forwarded' => $forwarded
    ];

    // Start timing
    $startTime = microtime(true);

    // Non-streaming request
    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
    $curlError = curl_error($ch);
    curl_close($ch);

    // Calculate duration
    $duration = microtime(true) - $startTime;

    // Separate headers and body
    $responseHeaders = substr($result, 0, $headerSize);
    $responseBody = substr($result, $headerSize);
    if (!isset($responseBody)) $responseBody = "";

    // Check if response is gzip compressed and decompress if needed
    $isGzipEncoded = false;
    $uncompressedBody = $responseBody;

    // Parse response headers to check for Content-Encoding: gzip
    $responseHeaderLines = explode("\r\n", $responseHeaders);
    foreach ($responseHeaderLines as $line) {
        if (!empty($line) && strpos($line, 'HTTP/') === false) {
            $headerParts = explode(':', $line, 2);
            if (count($headerParts) === 2) {
                $headerName = trim($headerParts[0]);
                $headerValue = trim($headerParts[1]);
                if (strtolower($headerName) === 'content-encoding' && strtolower($headerValue) === 'gzip') {
                    $isGzipEncoded = true;
                    break;
                }
            }
        }
    }

    // Decompress gzip response if needed
    if ($isGzipEncoded && !empty($responseBody)) {
        $uncompressedBody = gzdecode($responseBody);
        if ($uncompressedBody === false) {
            $uncompressedBody = $responseBody; // Fall back to original
        }
    }

    // Parse response and transform to OpenAI format
    $providerResponse = json_decode($uncompressedBody, true);
    if ($providerResponse!="") $logResponse = $providerResponse; else $logResponse=$uncompressedBody;

    $logResponse = [
        'http_code' => $httpCode,
        'stream' => false,
        'headers' => $responseHeaderLines,
        'data' => $logResponse,
    ];


    if ($curlError) {
        logTransaction($logRequest, $logResponse, $apiuserid, $apikeyid, $selectedprovider, $selectedrouteid, $duration, $curlError);
        $responseHttpCode = 500;
        $responseString = "";
        $error = 'Failed to connect to ' . $routeType . ' API: ' . $curlError;
        return false;
    }

    // Parse and forward response headers
    $responseHeaderLines = explode("\r\n", $responseHeaders);
    foreach ($responseHeaderLines as $line) {
        if (!empty($line) && strpos($line, 'HTTP/') === false) {
            // Skip hop-by-hop headers for the response
            $headerParts = explode(':', $line, 2);
            if (count($headerParts) === 2) {
                $headerName = trim($headerParts[0]);
                $headerValue = trim($headerParts[1]);
                
                $headerNameLower = strtolower($headerName);
                if (!in_array($headerNameLower, ['transfer-encoding', 'connection', 'keep-alive', 'proxy-authenticate', 'proxy-authorization', 'te', 'trailers', 'upgrade'])) {
                    header("$headerName: $headerValue");
                }
            }
        }
    }

    // Log successful transaction
    logTransaction($logRequest, $logResponse, $apiuserid, $apikeyid, $selectedprovider, $selectedrouteid, $duration);

    // Return the response
    $responseHttpCode = $httpCode;
    $responseString = $responseBody;
    return true;
}

function logModelListRequest($url,$resp,$httpCode)
{
    global $aigate_logdir, $apiuserid, $apikeyid, $selectedprovider, $selectedrouteid;

    $logRequest = [
        'client' => getClientIp(),
        'useragent' => $_SERVER['HTTP_USER_AGENT'],
        'method' => 'GET',
        'url' => $url,
        'headers' => getallheaders(),
        'request' => "",
    ];

    $responseHeaders["Content-Type"] = "application/json";
    
    $logResponse = [
        'http_code' => $httpCode,
        'stream' => false,
        'headers' => $responseHeaders,
        'data' => $resp,
    ];

    $duration = 0;

    logTransaction($logRequest, $logResponse, $apiuserid, $apikeyid, $selectedprovider, $selectedrouteid, $duration);
}

function ensureTrailingSlash(string $path)
{
    if (!str_ends_with($path, '/')) 
    {
        $path .= '/'; 
    }
    return $path;
}

?>