<?php
// Find the provider
global $apiuserid;
$debugModelList = false;
if ($debugModelList) error_log("gateway_inc_get.php: Model list request by user $apiuserid.");

if (!routingFindProvider(false,$apiuserid,$apikeyid,null,$selectedprovider,$selectedroute,$selectedmodelname,$error))
{
    http_response_code(400);
    header('Content-Type: application/json');
    $error = 'Could not find requested AI Model Provider. '.$error;
    if ($debugModelList) error_log("gateway_inc_get.php: $error");
    echo json_encode(['error' => $error]);
    exit;
}

$selectedrouteid = isset($selectedroute["id"]) ? $selectedroute["id"] : "";
$providerType = strtolower($selectedprovider['providerType']);
$providerId = strtolower($selectedprovider['id']);
$apiUrl = $selectedprovider["apiUrl"];
$apiKey = $selectedprovider["apiKey"];

if ($debugModelList) error_log("gateway_inc_get.php: Selected provider: $providerId ($providerType)");

if ($providerType == 'anthropic' && $requestPath === '/v1/models') {
    include_once("$servicesdir/aigate/api/gateway/anthropic/anthropic_inc_get_models.php");
    if ($debugModelList) error_log("gateway_inc_get.php: Model list request from Anthropic provider: ".json_encode($selectedprovider));
    processModelListRequest($selectedprovider,$responseString,$httpCode,$error);

    http_response_code($httpCode);
    header('Content-Type: application/json');
    echo $responseString;
    exit;
}

// Handle model list request
if ($requestPath === '/v1/models') {
    include_once("$servicesdir/aigate/api/gateway/openai/openai_inc_get_models.php");
    if ($debugModelList) error_log("gateway_inc_get.php: Model list request from OpenAI provider: ".json_encode($selectedprovider));
    processModelListRequest($selectedprovider,$responseString,$httpCode,$error);
    
    http_response_code($httpCode);
    header('Content-Type: application/json');
    echo $responseString;
    exit;
}

// Forward all other GET requests to the selected provider
$url = $apiUrl.$requestPath;

if (!downloadFromUrl($url,$apiKey,$responseString,$httpCode,$error))
{
    http_response_code(500);
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Failed to connect to ' . $routeType . ' API: ' . $error]);
    exit;
}

http_response_code($httpCode);
header('Content-Type: application/json');
echo $responseString;

exit;
?>