<?php
function determineInputFormat($path, $preferredProviderType = '')
{
    switch (strtolower($preferredProviderType)) {
        case 'openai':
            return 'openai compatible';
        case 'openai compatible':
        case 'anthropic':
        case 'ollama':
            return strtolower($preferredProviderType);
    }

    //todo auto detect input format based on post data as well
    $pathLower = strtolower($path);
    if (strpos($pathLower, '/v1/messages') === 0 || strpos($pathLower, '/v1/models') === 0) {
        return 'anthropic';
    }
    if (strpos($pathLower, '/api/') === 0) {
        return 'ollama';
    }
    return 'openai compatible';
}
?>