<?php

function isRequestAuthorized($input,&$apikey,&$apikeyid,&$apiuserid,&$error)
{
    global $servicesdir;
    //error_log("gateway_auth.php: Request authorization.");

    //Model list request
    if (isValidModelListRequest())
    {
        $apikeyid = "";
        $apiuserid = "";
        $error = "";
        return true;
    } 

    //Signed input request
    if (isSignedInput($input,$apiuserid,$error))
    {
        $apikeyid = "";
        return true;
    }

    //Api key check
    include_once("$servicesdir/aigate/api/apikey/apikey_check.php");
    if (!requireBearerToken($apikey,$error) || !isApiKeyValid($apikey,$apiuserid,$error))
        return false;
    
    $apikeyid = md5($apikey);
    return true;    
}

function isValidModelListRequest()
{
    if ($_SERVER['REQUEST_METHOD'] !== 'GET') return false;
    if (parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH) !== '/v1/models') return false;

    $headers = array_combine(
        array_map('strtolower', array_keys(getallheaders())),
        array_values(getallheaders())
    );

    //error_log("gateway_autho.php, Header list: ".json_encode($headers));
    if (!isset($headers['ozeki-aiprovider-id'])) return false;
    global $ozekiAIProviderID;
    $ozekiAIProviderID = $headers['ozeki-aiprovider-id'];
    error_log("Lookup models for: ".$ozekiAIProviderID);
    return true;
}

function isSignedInput($input,&$apiuserid,&$error)
{
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') return false;
    $headers = array_combine(
        array_map('strtolower', array_keys(getallheaders())),
        array_values(getallheaders())
    );

    if (!isset($headers['ozeki-aiprovider-id'])) return false;

    if (!checkSignature($input,$userid,$station,$error)) return false;

    global $ozekiAIProviderID;
    $ozekiAIProviderID = $headers['ozeki-aiprovider-id'];
    return true;
}
?>