<?php
/**
 *  Ozeki AI API Gateway with Routing
 * --------------- 
 * Apache config:
 * C:\wamp64\bin\apache\apache2.4.51\conf\extra\httpd-vhosts.conf
 * RewriteEngine On
 * #LogLevel alert rewrite:trace
 * RewriteRule ^/v1(.*) /ozeki/index.php?srv=aigate&api=gateway&path==$1
 * ErrorLog "c:/wamp64/logs/ozeki-error.log"
 * CustomLog "c:/wamp64/logs/ozeki-access.log" common
 * 
 * URL: 
 * http://localhost/v1/models  (before rewrite)
 * http://localhost/ozeki/index.php?srv=aigate&api=gateway&path=/v1/models
 */

date_default_timezone_set("UTC");
$aigate_request_timeout = 900; //sec

// Require the logging utilities and configuration
include_once("$servicesdir/aigate/api/gateway/gateway_inc.php");
include_once("$servicesdir/aigate/api/gateway/gateway_logger.php");
include_once("$servicesdir/aigate/api/gateway/gateway_routing.php");
include_once("$servicesdir/aigate/api/gateway/gateway_auth.php");

// Load configurations
include_once("$servicesdir/aigate/setup.php");

// Determine the current request path for routing
$requestUri = $_REQUEST["path"] ?? '';
$requestProviderType = $_REQUEST["providertype"] ?? '';
$requestPath = parse_url($requestUri, PHP_URL_PATH) ?: '';

// Determine input format and include appropriate request handler
$inputFormat = determineInputFormat($requestPath, $requestProviderType);
switch ($inputFormat) {
    case 'anthropic':
        include_once("$servicesdir/aigate/api/gateway/gateway_reqhandler_anthropic.php");
        break;
    case 'openai compatible':
    default:
        include_once("$servicesdir/aigate/api/gateway/gateway_reqhandler_openai.php");
        break;
}

// Set headers to allow CORS and JSON responses
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
//header('Content-Type: application/json');

// Handle preflight OPTIONS request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

// Get raw POST data
$input = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') 
{
    $input = file_get_contents('php://input');
}

// Identify the user
if (!isRequestAuthorized($input, $apikey, $apikeyid, $apiuserid, $error))
{
    error_log("gateway_inc.php, authorization error. ".$error);
    $errorobj["error"] = [
            "message"=> $error,
            "type"=> "invalid_request_error",
            "param"=> null,
            "code"=> null
    ];
    http_response_code(401);
    echo json_encode($errorobj);
    exit;
}
//error_log("gateway_inc.php, authorized request. User ID: $apiuserid. $apikeyid");

// Handle GET requests
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    include_once("$servicesdir/aigate/api/gateway/gateway_inc_get.php");
    http_response_code(405);
    echo json_encode(['error' => 'Unexpected GET request.']);
    exit;
}

// Handle POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed. Use POST.']);
    exit;
}

include_once("$servicesdir/aigate/api/gateway/gateway_inc_post.php");
exit;
?>