<?php
include_once("$servicesdir/aigate/api/gateway/gateway_inc_get_models.php");

function processModelListRequest($selectedprovider,&$responseData,&$httpCode,&$error)
{
    global $datadir,$debugModelList;

    $httpCode = 500;
    $responseData = [];
    $error = "";

    // If providerType is not "Provider group" download it's model list
    if (!isset($selectedprovider["providerType"]) || $selectedprovider["providerType"] != "Provider group") {
        $ret = processModelListRequestForProvider($selectedprovider,$responseData,$httpCode);
        return $ret;
    }
    
    // If providerType is a "Provider group", get the model list for each group member
    $providerDir = "$datadir/services/aigate/providers";
    
    if (!isset($selectedprovider["availableProviders"]) || !is_array($selectedprovider["availableProviders"])) {
        $error = "gateway_inc_getmodels.php: Provider group has no availableProviders array";
        return false;
    }

    $modelresp = [];
    $modelresp["data"] = [];
    
    $providerOptions = $selectedprovider["availableProviders"];
    if ($debugModelList) error_log("gateway_inc_getmodels.php: Returning models from provider options: ".json_encode($providerOptions));
    foreach ($providerOptions as $providerid) {
        $providerdetails = "$providerDir/$providerid/content.dat";
        
        if (!ozreadjson($providerdetails, $provider, $error)) {
            if ($debugModelList) error_log("gateway_inc_getmodels.php: AI model provider not found while looking for id: $providerid. $error");
            continue;
        }
        
        // Get model list for this provider
        $providerModels = [];
        if (!getModelsFromProvider($provider, $providerModels, $error)) {
            if ($debugModelList) error_log("gateway_inc_getmodels.php: Failed to get models from provider $providerid: $error");
            continue;
        }
        
        // Format model names as "name/modelName" with spaces replaced by "-"
        $providerName = str_replace(' ', '-', $provider["name"]);
        
        foreach ($providerModels as $model) {
            $modelname = $providerName . "/" . $model;
            $modelresp["data"][] = createModelDataItem($provider, $modelname);
        }
    }

    $modelresp["first_id"] = count($modelresp["data"])>0 ? $modelresp["data"][0]["id"] : "";
    $modelresp["has_more"] = false;
    $modelresp["last_id"] = count($modelresp["data"])>0 ? $modelresp["data"][count($modelresp["data"])-1]["id"] : "";

    $httpCode = 200;
    $responseData = json_encode($modelresp, JSON_PRETTY_PRINT);
    return true;
}

function processModelListRequestForProvider($provider,&$responseData,&$httpCode)
{
    global $debugModelList;

    $apiUrl = $provider["apiUrl"];
    $apiKey = $provider["apiKey"];

    $url = ensureTrailingSlash($apiUrl)."models";

    //Download all models from provider
    if (isset($provider["allowOtherModels"]) && $provider["allowOtherModels"] &&
        isset($provider["allowAllModelsOffered"]) &&  $provider["allowAllModelsOffered"])
    {
        if (!downloadFromUrl($url,$apiKey,$responseData,$httpCode,$error))
        {
            if ($debugModelList) error_log("Downloading model list failed: $error");
            logModelListRequest($url,$responseData,$httpCode);
            return false;
        }

        logModelListRequest($url,$responseData,$httpCode);
        return true;
    }

    //Return selected models
    if (isset($provider["allowOtherModels"]) && $provider["allowOtherModels"] &&
       (!isset($provider["allowAllModelsOffered"]) ||  !$provider["allowAllModelsOffered"]) &&
       isset($provider["allowedModels"]) && 
       is_array($provider["allowedModels"]) && 
       count($provider["allowedModels"])>0
       )
    {
        $modelresp = [];
        foreach($provider["allowedModels"] as $model)
        {
            $modelresp["data"][] = createModelDataItem($provider,$model);
        }
        $modelresp["first_id"] = $provider["allowedModels"][0];
        $modelresp["has_more"] = false;
        $modelresp["last_id"] = $provider["allowedModels"][count($provider["allowedModels"])-1];

        $httpCode = 200;
        $responseData = json_encode($modelresp, JSON_PRETTY_PRINT);
        logModelListRequest($url,$responseData,$httpCode);
        return true;
    }

    //Return the preferred model only
    if (!isset($provider["allowOtherModels"]) || !$provider["allowOtherModels"])
    {
        //error_log("Downloading model list form url: $url, using api key: $apiKey");
        $modelresp = [];
        $modelresp["data"][] = createModelDataItem($provider,$provider["modelName"]);
        $modelresp["first_id"] = $provider["modelName"];
        $modelresp["has_more"] = false;
        $modelresp["last_id"] = $provider["modelName"];

        $httpCode = 200;
        $responseData = json_encode($modelresp, JSON_PRETTY_PRINT);
        logModelListRequest($url,$responseData,$httpCode);
        return true;
    }

    return true;
}

function getModelsFromProvider($provider, &$models, &$error)
{
    $apiUrl = $provider["apiUrl"];
    $apiKey = $provider["apiKey"];
    
    $url = ensureTrailingSlash($apiUrl)."models";
    
    // Download all models from provider
    if (isset($provider["allowOtherModels"]) && $provider["allowOtherModels"] &&
        isset($provider["allowAllModelsOffered"]) && $provider["allowAllModelsOffered"]) 
    {
        if (!downloadFromUrl($url, $apiKey, $responseData, $httpCode, $error)) {
            return false;
        }
        
        $providerResponse = json_decode($responseData, true);
        if (!isset($providerResponse["data"]) || !is_array($providerResponse["data"])) {
            $error = "Invalid response format from provider";
            return false;
        }
        
        foreach ($providerResponse["data"] as $model) {
            $models[] = $model["id"];
        }
        return true;
    }
    
    // Return selected models
    if (isset($provider["allowOtherModels"]) && $provider["allowOtherModels"] &&
       (!isset($provider["allowAllModelsOffered"]) || !$provider["allowAllModelsOffered"]) &&
       isset($provider["allowedModels"]) &&
       is_array($provider["allowedModels"]) &&
       count($provider["allowedModels"]) > 0) 
    {
        $models = $provider["allowedModels"];
        return true;
    }
    
    // Return the preferred model only
    if (!isset($provider["allowOtherModels"]) || !$provider["allowOtherModels"]) 
    {
        $models = [$provider["modelName"]];
        return true;
    }
    
    return true;
}

function createModelDataItem($provider, $modelname)
{
    $model = [];
    $model["id"] = $modelname;
    $model["created_at"] = "2026-01-29T00:00:00Z";
    $model["display_name"] = $modelname;
    $model["type"] = "model";
    return $model;
}

?>