<?php
/**
 * Handle request to update an API key
 *
 * @param string $userid
 * @param array  $req   Request data
 * @param array  &$resp Response data (by reference)
 * @return bool
 */

function handlerequest_updateapikey($userid,$req,&$resp)
{
    $status = "UPDATED";
    $error = "";

    if (!apiKeyExistsForUpdate($req,$error))
    {
        error_log("apikey_update.php: API key not found. $error. Request by user $userid" . json_encode($req));
        $status = "ERROR";
    }

    else if (!updateApiKey($userid,$req,$error))
    {
        error_log("apikey_update.php: Could not update API key. $error. Request by user $userid" . json_encode($req));
        $status = "ERROR";
    }
    
    // Build response
    $resp["status"]        = "OK";
    $resp["updateresult"]  = $status;
    $resp["errormessage"]  = $error;
    return true;
}

function apiKeyExistsForUpdate($req,&$error)
{
    global $datadir;

    $dir = "$datadir/services/aigate/apikeys/keys";
    $filename = "$dir/".$req["id"];
    if (!file_exists($filename))
    {
        $error = "Api key not found for update";
        return false;
    }

    $error = "";
    return true;
}

function updateApiKey($userid,$req,&$error)
{
    global $adminuser,$datadir;

    $dir = "$datadir/services/aigate/apikeys/keys";
    $filename = "$dir/".$req["id"];
    
    // Load existing API key data
    if (!ozreadjson($filename, $existingData, $error)) {
        return false;
    }

    if (!array_key_exists("keydata", $req))
    {
        $error = "Api key updated data not found";
        return false;
    }

    // Update only the allowed fields
    $changed = false;
    foreach($req["keydata"] as $key=>$val)
    {
        if (in_array($key,array("id",
        "owneruserid",
        "createdbyuserid",
        "signature",
        "encryptedforowner",
        "encryptedforcreatedbyuser",
        "encryptedforadmin"))) continue;

        $existingData[$key] = $val;
        $changed = true;
    }

    // Save the updated data
    if ($changed && !ozsavejson($filename, $existingData, $error)) {
        return false;
    }

    $error = "";
    return true;
}

/*
//Input
{
    id: "apikeyid", // MD5 hash of the API key
    action: 'updateapikey',
    owneruserid: userId,
    comment: "Updated comment", // optional
    validuntil: "2025-12-31 23:59:59" // optional
};

//Response
{
    status: "OK",
    updateresult: "UPDATED",
    errormessage: ""
}
*/
?>
