<?php
/**
 * Handle request to list comments for API keys
 *
 * @param string $userid
 * @param array  $req   Request data
 * @param array  &$resp Response data (by reference)
 * @return bool
 */

function handlerequest_listcomments($userid, $req, &$resp)
{
    $error = "";

    // Parameter: apikeyids (comma-separated list of API key IDs)
    $apikeyids = $req["apikeyids"];

    if (empty($apikeyids)) {
        $error = 'Parameter "apikeyids" is required.';
        ozerror(__FILE__, $error, $resp, $error);
        $resp["status"] = "ERROR";
        $resp["errormessage"] = $error;
        return false;
    }

    $ids = array_map('trim', explode(',', $apikeyids));
    $comments = array();
    $owneruserids = array();

    global $datadir;
    $keysdir = "$datadir/services/aigate/apikeys/keys";

    foreach ($ids as $apikeyid) {
        $keyfile = "$keysdir/$apikeyid";

        if (file_exists($keyfile)) {
            $apikeydata = array();
            $fileerror = "";

            if (ozreadjson($keyfile, $apikeydata, $fileerror)) {
                // Extract the comment field if it exists
                if (isset($apikeydata["comment"])) {
                    $comments[$apikeyid] = $apikeydata["comment"];
                } else {
                    $comments[$apikeyid] = "";
                }
                
                // Extract the owneruserid field if it exists
                if (isset($apikeydata["owneruserid"])) {
                    $owneruserids[$apikeyid] = $apikeydata["owneruserid"];
                } else {
                    $owneruserids[$apikeyid] = "";
                }
            } else {
                $error .= "Could not read API key file: $apikeyid. $fileerror. ";
                $comments[$apikeyid] = "ERROR: Could not read file";
                $owneruserids[$apikeyid] = "ERROR: Could not read file";
            }
        } else {
            $error .= "API key file not found: $apikeyid. ";
            $comments[$apikeyid] = "ERROR: File not found";
            $owneruserids[$apikeyid] = "ERROR: File not found";
        }
    }

    // Build response
    $resp["status"] = "OK";
    $resp["errormessage"] = $error;
    $resp["comments"] = $comments;
    $resp["owneruserids"] = $owneruserids;

    return true;
}

/*
// Input
{
    action: 'listcomments',
    apikeyids: 'keyid1,keyid2,keyid3'  // comma-separated list of API key IDs
};

// Response
{
    status: "OK",
    listresult: "LISTED",
    errormessage: "",
    comments: {
        "keyid1": "Comment for key 1",
        "keyid2": "Comment for key 2",
        "keyid3": "ERROR: File not found"
    }
}
*/
?>
