<?php
/**
 * Handle request to list API keys for a user
 *
 * @param string $userid
 * @param array  $req   Request data
 * @param array  &$resp Response data (by reference)
 * @return bool
 */

function handlerequest_apikeylist($userid,$req,&$resp)
{
    $status = "LISTED";
    $error = "";

    // Get the owner user ID from request, default to the requesting user if not specified
    $owneruserid = isset($req["owneruserid"]) ? $req["owneruserid"] : $userid;

    // Load API keys for the specified user
    $apikeys = loadUserApiKeys($owneruserid, $error);

    if ($error != "") {
        error_log("apikey_list.php: Could not load API keys. $error. Request by user $userid");
        $status = "ERROR";
    }

    // Build response
    $resp["status"]        = "OK";
    $resp["listresult"]    = $status;
    $resp["errormessage"]  = $error;
    $resp["apikeys"]       = $apikeys;
    $resp["owneruserid"]   = $owneruserid;

    return true;
}

function loadUserApiKeys($owneruserid, &$error)
{
    global $datadir;

    $apikeys = array();
    $error = "";

    // Path to the user's API keys list
    $userdir = "$datadir/services/aigate/apikeys/users/$owneruserid";
    $apikeysfile = "$userdir/apikeys.json";

    // Check if the user's API keys file exists
    if (!file_exists($apikeysfile)) {
        $error = "No API keys found for user $owneruserid";
        return $apikeys;
    }

    // Load the list of API key IDs
    if (!ozreadjson($apikeysfile, $apikeyids, $error))
    {
        $error = "No API keys file found for user $owneruserid";
        return $apikeys;
    }

    // If no API keys in the list, return empty array
    if (empty($apikeyids)) {
        return $apikeys;
    }

    // Load details for each API key
    $keysdir = "$datadir/services/aigate/apikeys/keys";

    foreach ($apikeyids as $apikeyid) {
        $keyfile = "$keysdir/$apikeyid";

        if (file_exists($keyfile) && ozreadjson($keyfile, $apikeydata, $error))
        {
            // Add the API key data to the result, including the ID
            $apikeydata["id"] = $apikeyid;
            $apikeys[] = $apikeydata;
        }
    }

    return $apikeys;
}

/*
//Input
{
    action: 'listapikeys',
    owneruserid : userId,  // optional, defaults to requesting user
};

//Response
{
    status: "OK",
    listresult: "LISTED",
    errormessage: "",
    owneruserid: "userId",
    apikeys: [
        {
            "id": "apikeyid1",
            "owneruserid": "userId",
            "createdbyuserid": "creatorId",
            "encryptedforowner": "enc_data",
            "encryptedforadmin": "enc_data",
            "encryptedforcreatedbyuser": "enc_data",
            "createdate": "2024-01-15 10:30:00",
            "validuntil": "2025-12-31 23:59:59",
            "comment": "API key comment",
            "signature": "signature_data"
        },
        ...
    ]
}
*/
?>
