
<?php
/**
 * Handle request to delete an API key
 *
 * @param string $userid
 * @param array  $req   Request data
 * @param array  &$resp Response data (by reference)
 * @return bool
 */

function handlerequest_deleteapikey($userid,$req,&$resp)
{
    $status = "DELETED";
    $error = "";

    if (!deleteApiKey($userid,$req,$error))
    {
        error_log("apikey_delete.php: Could not delete API key. $error. Request by user $userid" . json_encode($req));
        $status = "ERROR";
    }

    // Build response
    $resp["status"]        = "OK";
    $resp["deleteresult"]  = $status;
    $resp["errormessage"]  = $error;
    return true;
}

function deleteApiKey($userid,$req,&$error)
{
    global $datadir;
    
    $dir = "$datadir/services/aigate/apikeys/keys";
    $filename = "$dir/".$req["id"];

    if (!file_exists($filename))
    {
        $error = "API key not found";
        return false;
    }

    // Delete the API key file
    if (!unlink($filename))
    {
        $error = "Failed to delete API key file";
        return false;
    }

    // Remove API key ID from owner's JSON list
    if (!removeApiKeyFromOwnerList($req["owneruserid"], $req["id"], $error)) {
        error_log("apikey_delete.php: Could not remove API key ID from owner's list. $error. Request by user $userid" . json_encode($req));
    }

    $error = "";
    return true;
}

function removeApiKeyFromOwnerList($owneruserid, $apikeyid, &$error)
{
    global $datadir;

    $userdir = "$datadir/services/aigate/apikeys/users/$owneruserid";
    $apikeysfile = "$userdir/apikeys.json";

    // Load existing API keys if the file exists
    if (file_exists($apikeysfile)) {
         if (!ozreadjson($apikeysfile, $apikeyslist, $error))
        {
            return false;
        }

        // Remove the API key ID from the list
        $newlist = array_diff($apikeyslist, array($apikeyid));

        // Save the updated list
        if (!ozsavejson($apikeysfile, $newlist, $error)) {
            return false;
        }
    }

    return true;
}

/*
//Input
{
id :  md5(apiKeyToDelete),
apikey : apiKeyToDelete,
action: 'deleteapikey',
owneruserid : userId,
};


*/
?>