<?php

function isApiKeyValid($apikey,&$userid,&$error)
{
    global $datadir;

    $dir = "$datadir/services/aigate/apikeys/keys";
    $filename = "$dir/".md5($apikey);
    if (!file_exists($filename))
    {
        $error = "API key error. Api key does not exist";
        return false;
    }

    if (!ozreadjson($filename,$a,$error))
    {
        $error = "API key error. Api key file corrupt: ".md5($apikey);
        return false;
    }

    $userid = $a["owneruserid"];

    if (!ismd5($userid) || !userExists($userid))
    {
         $error = "API key error. User does not exist: ".$userid;
        return false;
    }

    $error = "";
    return true;
}


function requireBearerToken(&$receivedToken,&$error): bool
{
    // 1. Try Apache/Nginx built-in variable first
    $header = $_SERVER['HTTP_AUTHORIZATION'] ?? '';

    // 2. Some setups send it as REDIRECT_HTTP_AUTHORIZATION
    if (!$header && isset($_SERVER['REDIRECT_HTTP_AUTHORIZATION'])) {
        $header = $_SERVER['REDIRECT_HTTP_AUTHORIZATION'];
    }

    // 3. If still nothing, PHP can parse the apache_request_headers() result
    if (!$header && function_exists('apache_request_headers')) {
        $all = apache_request_headers();
        // Authorization headers are case-insensitive
        $all = array_change_key_case($all, CASE_LOWER);
        $header = $all['authorization'] ?? '';
    }

    // 4. Validate the format: "Bearer <token>"
    if (!preg_match('/^Bearer\s+(\S+)$/', trim($header), $matches)) {
        $error = "Bearer token missing or malformed";
        $receivedToken = "";
        return false;
    }

    $error = "";
    $receivedToken = $matches[1];   // return the raw token string
    return true;
}


?>